@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name Project's name.
 * @property type Build output artifact's type. Valid values: `CODEPIPELINE`, `NO_ARTIFACTS`, `S3`.
 * @property value Environment variable's value.
 */
public data class ProjectEnvironmentEnvironmentVariable(
    public val name: String,
    public val type: String? = null,
    public val `value`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.ProjectEnvironmentEnvironmentVariable):
            ProjectEnvironmentEnvironmentVariable = ProjectEnvironmentEnvironmentVariable(
            name = javaType.name(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`(),
        )
    }
}
