@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property credential ARN or name of credentials created using AWS Secrets Manager.
 * @property credentialProvider Service that created the credentials to access a private Docker registry. Valid value: `SECRETS_MANAGER` (AWS Secrets Manager).
 */
public data class ProjectEnvironmentRegistryCredential(
    public val credential: String,
    public val credentialProvider: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.ProjectEnvironmentRegistryCredential):
            ProjectEnvironmentRegistryCredential = ProjectEnvironmentRegistryCredential(
            credential = javaType.credential(),
            credentialProvider = javaType.credentialProvider(),
        )
    }
}
