@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property identifier The name used to access a file system created by Amazon EFS. CodeBuild creates an environment variable by appending the identifier in all capital letters to CODEBUILD\_. For example, if you specify my-efs for identifier, a new environment variable is create named CODEBUILD_MY-EFS.
 * @property location A string that specifies the location of the file system created by Amazon EFS. Its format is `efs-dns-name:/directory-path`.
 * @property mountOptions The mount options for a file system created by AWS EFS.
 * @property mountPoint The location in the container where you mount the file system.
 * @property type The type of the file system. The one supported type is `EFS`.
 */
public data class ProjectFileSystemLocation(
    public val identifier: String? = null,
    public val location: String? = null,
    public val mountOptions: String? = null,
    public val mountPoint: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.ProjectFileSystemLocation):
            ProjectFileSystemLocation = ProjectFileSystemLocation(
            identifier = javaType.identifier().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            mountOptions = javaType.mountOptions().map({ args0 -> args0 }).orElse(null),
            mountPoint = javaType.mountPoint().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
