@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property cloudwatchLogs Configuration block. Detailed below.
 * @property s3Logs Configuration block. Detailed below.
 */
public data class ProjectLogsConfig(
    public val cloudwatchLogs: ProjectLogsConfigCloudwatchLogs? = null,
    public val s3Logs: ProjectLogsConfigS3Logs? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.ProjectLogsConfig):
            ProjectLogsConfig = ProjectLogsConfig(
            cloudwatchLogs = javaType.cloudwatchLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codebuild.kotlin.outputs.ProjectLogsConfigCloudwatchLogs.Companion.toKotlin(args0)
                })
            }).orElse(null),
            s3Logs = javaType.s3Logs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codebuild.kotlin.outputs.ProjectLogsConfigS3Logs.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
