@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property groupName Group name of the logs in CloudWatch Logs.
 * @property status Current status of logs in S3 for a build project. Valid values: `ENABLED`, `DISABLED`. Defaults to `DISABLED`.
 * @property streamName Stream name of the logs in CloudWatch Logs.
 */
public data class ProjectLogsConfigCloudwatchLogs(
    public val groupName: String? = null,
    public val status: String? = null,
    public val streamName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.ProjectLogsConfigCloudwatchLogs):
            ProjectLogsConfigCloudwatchLogs = ProjectLogsConfigCloudwatchLogs(
            groupName = javaType.groupName().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            streamName = javaType.streamName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
