@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property sourceIdentifier An identifier for a source in the build project.
 * @property sourceVersion The source version for the corresponding source identifier. See [AWS docs](https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ProjectSourceVersion.html#CodeBuild-Type-ProjectSourceVersion-sourceVersion) for more details.
 */
public data class ProjectSecondarySourceVersion(
    public val sourceIdentifier: String,
    public val sourceVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.ProjectSecondarySourceVersion):
            ProjectSecondarySourceVersion = ProjectSecondarySourceVersion(
            sourceIdentifier = javaType.sourceIdentifier(),
            sourceVersion = javaType.sourceVersion(),
        )
    }
}
