@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property excludeMatchedPattern If set to `true`, the specified filter does *not* trigger a build. Defaults to `false`.
 * @property pattern For a filter that uses `EVENT` type, a comma-separated string that specifies one event: `PUSH`, `PULL_REQUEST_CREATED`, `PULL_REQUEST_UPDATED`, `PULL_REQUEST_REOPENED`. `PULL_REQUEST_MERGED` works with GitHub & GitHub Enterprise only. For a filter that uses any of the other filter types, a regular expression.
 * @property type The webhook filter group's type. Valid values for this parameter are: `EVENT`, `BASE_REF`, `HEAD_REF`, `ACTOR_ACCOUNT_ID`, `FILE_PATH`, `COMMIT_MESSAGE`. At least one filter group must specify `EVENT` as its type.
 */
public data class WebhookFilterGroupFilter(
    public val excludeMatchedPattern: Boolean? = null,
    public val pattern: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.WebhookFilterGroupFilter):
            WebhookFilterGroupFilter = WebhookFilterGroupFilter(
            excludeMatchedPattern = javaType.excludeMatchedPattern().map({ args0 -> args0 }).orElse(null),
            pattern = javaType.pattern(),
            type = javaType.type(),
        )
    }
}
