@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecatalyst.kotlin

import com.pulumi.aws.codecatalyst.kotlin.outputs.DevEnvironmentIdes
import com.pulumi.aws.codecatalyst.kotlin.outputs.DevEnvironmentPersistentStorage
import com.pulumi.aws.codecatalyst.kotlin.outputs.DevEnvironmentRepository
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.codecatalyst.kotlin.outputs.DevEnvironmentIdes.Companion.toKotlin as devEnvironmentIdesToKotlin
import com.pulumi.aws.codecatalyst.kotlin.outputs.DevEnvironmentPersistentStorage.Companion.toKotlin as devEnvironmentPersistentStorageToKotlin
import com.pulumi.aws.codecatalyst.kotlin.outputs.DevEnvironmentRepository.Companion.toKotlin as devEnvironmentRepositoryToKotlin

/**
 * Builder for [DevEnvironment].
 */
@PulumiTagMarker
public class DevEnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DevEnvironmentArgs = DevEnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DevEnvironmentArgsBuilder.() -> Unit) {
        val builder = DevEnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DevEnvironment {
        val builtJavaResource = com.pulumi.aws.codecatalyst.DevEnvironment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DevEnvironment(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS CodeCatalyst Dev Environment.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecatalyst.DevEnvironment;
 * import com.pulumi.aws.codecatalyst.DevEnvironmentArgs;
 * import com.pulumi.aws.codecatalyst.inputs.DevEnvironmentIdesArgs;
 * import com.pulumi.aws.codecatalyst.inputs.DevEnvironmentPersistentStorageArgs;
 * import com.pulumi.aws.codecatalyst.inputs.DevEnvironmentRepositoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new DevEnvironment("test", DevEnvironmentArgs.builder()
 *             .alias("devenv")
 *             .ides(DevEnvironmentIdesArgs.builder()
 *                 .name("PyCharm")
 *                 .runtime("public.ecr.aws/jetbrains/py")
 *                 .build())
 *             .inactivityTimeoutMinutes(40)
 *             .instanceType("dev.standard1.small")
 *             .persistentStorage(DevEnvironmentPersistentStorageArgs.builder()
 *                 .size(16)
 *                 .build())
 *             .projectName("myproject")
 *             .repositories(DevEnvironmentRepositoryArgs.builder()
 *                 .branchName("main")
 *                 .repositoryName("pulumi-provider-aws")
 *                 .build())
 *             .spaceName("myspace")
 *             .build());
 *     }
 * }
 * ```
 */
public class DevEnvironment internal constructor(
    override val javaResource: com.pulumi.aws.codecatalyst.DevEnvironment,
) : KotlinCustomResource(javaResource, DevEnvironmentMapper) {
    public val alias: Output<String>?
        get() = javaResource.alias().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Information about the integrated development environment (IDE) configured for a Dev Environment.
     */
    public val ides: Output<DevEnvironmentIdes>
        get() = javaResource.ides().applyValue({ args0 ->
            args0.let({ args0 ->
                devEnvironmentIdesToKotlin(args0)
            })
        })

    /**
     * The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
     */
    public val inactivityTimeoutMinutes: Output<Int>?
        get() = javaResource.inactivityTimeoutMinutes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge
     * The following arguments are optional:
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * Information about the amount of storage allocated to the Dev Environment.
     */
    public val persistentStorage: Output<DevEnvironmentPersistentStorage>
        get() = javaResource.persistentStorage().applyValue({ args0 ->
            args0.let({ args0 ->
                devEnvironmentPersistentStorageToKotlin(args0)
            })
        })

    /**
     * The name of the project in the space.
     */
    public val projectName: Output<String>
        get() = javaResource.projectName().applyValue({ args0 -> args0 })

    /**
     * The source repository that contains the branch to clone into the Dev Environment.
     */
    public val repositories: Output<List<DevEnvironmentRepository>>?
        get() = javaResource.repositories().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> devEnvironmentRepositoryToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The name of the space.
     */
    public val spaceName: Output<String>
        get() = javaResource.spaceName().applyValue({ args0 -> args0 })
}

public object DevEnvironmentMapper : ResourceMapper<DevEnvironment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codecatalyst.DevEnvironment::class == javaResource::class

    override fun map(javaResource: Resource): DevEnvironment = DevEnvironment(
        javaResource as
            com.pulumi.aws.codecatalyst.DevEnvironment,
    )
}

/**
 * @see [DevEnvironment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DevEnvironment].
 */
public suspend fun devEnvironment(
    name: String,
    block: suspend DevEnvironmentResourceBuilder.() -> Unit,
): DevEnvironment {
    val builder = DevEnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DevEnvironment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun devEnvironment(name: String): DevEnvironment {
    val builder = DevEnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
