@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecatalyst.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SourceRepository].
 */
@PulumiTagMarker
public class SourceRepositoryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SourceRepositoryArgs = SourceRepositoryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SourceRepositoryArgsBuilder.() -> Unit) {
        val builder = SourceRepositoryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SourceRepository {
        val builtJavaResource = com.pulumi.aws.codecatalyst.SourceRepository(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SourceRepository(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS CodeCatalyst Source Repository.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecatalyst.SourceRepository;
 * import com.pulumi.aws.codecatalyst.SourceRepositoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SourceRepository("example", SourceRepositoryArgs.builder()
 *             .projectName("example-project")
 *             .spaceName("example-space")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeCatalyst Source Repository using the `example_id_arg`. For example:
 * ```sh
 *  $ pulumi import aws:codecatalyst/sourceRepository:SourceRepository example source_repository-id-12345678
 * ```
 *
 */
public class SourceRepository internal constructor(
    override val javaResource: com.pulumi.aws.codecatalyst.SourceRepository,
) : KotlinCustomResource(javaResource, SourceRepositoryMapper) {
    /**
     * The description of the project. This description will be displayed to all users of the project. We recommend providing a brief description of the project and its intended purpose.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the source repository. For more information about name requirements, see [Quotas for source repositories](https://docs.aws.amazon.com/codecatalyst/latest/userguide/source-quotas.html).
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the project in the CodeCatalyst space.
     * The following arguments are optional:
     */
    public val projectName: Output<String>
        get() = javaResource.projectName().applyValue({ args0 -> args0 })

    /**
     * The name of the CodeCatalyst space.
     */
    public val spaceName: Output<String>
        get() = javaResource.spaceName().applyValue({ args0 -> args0 })
}

public object SourceRepositoryMapper : ResourceMapper<SourceRepository> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codecatalyst.SourceRepository::class == javaResource::class

    override fun map(javaResource: Resource): SourceRepository = SourceRepository(
        javaResource as
            com.pulumi.aws.codecatalyst.SourceRepository,
    )
}

/**
 * @see [SourceRepository].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SourceRepository].
 */
public suspend fun sourceRepository(
    name: String,
    block: suspend SourceRepositoryResourceBuilder.() -> Unit,
): SourceRepository {
    val builder = SourceRepositoryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SourceRepository].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sourceRepository(name: String): SourceRepository {
    val builder = SourceRepositoryResourceBuilder()
    builder.name(name)
    return builder.build()
}
