@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecatalyst.kotlin

import com.pulumi.aws.codecatalyst.SourceRepositoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS CodeCatalyst Source Repository.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecatalyst.SourceRepository;
 * import com.pulumi.aws.codecatalyst.SourceRepositoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SourceRepository("example", SourceRepositoryArgs.builder()
 *             .projectName("example-project")
 *             .spaceName("example-space")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeCatalyst Source Repository using the `example_id_arg`. For example:
 * ```sh
 *  $ pulumi import aws:codecatalyst/sourceRepository:SourceRepository example source_repository-id-12345678
 * ```
 * @property description The description of the project. This description will be displayed to all users of the project. We recommend providing a brief description of the project and its intended purpose.
 * @property name The name of the source repository. For more information about name requirements, see [Quotas for source repositories](https://docs.aws.amazon.com/codecatalyst/latest/userguide/source-quotas.html).
 * @property projectName The name of the project in the CodeCatalyst space.
 * The following arguments are optional:
 * @property spaceName The name of the CodeCatalyst space.
 */
public data class SourceRepositoryArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val spaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codecatalyst.SourceRepositoryArgs> {
    override fun toJava(): com.pulumi.aws.codecatalyst.SourceRepositoryArgs =
        com.pulumi.aws.codecatalyst.SourceRepositoryArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .spaceName(spaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SourceRepositoryArgs].
 */
@PulumiTagMarker
public class SourceRepositoryArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var projectName: Output<String>? = null

    private var spaceName: Output<String>? = null

    /**
     * @param value The description of the project. This description will be displayed to all users of the project. We recommend providing a brief description of the project and its intended purpose.
     */
    @JvmName("ekspfliroykfvlrr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the source repository. For more information about name requirements, see [Quotas for source repositories](https://docs.aws.amazon.com/codecatalyst/latest/userguide/source-quotas.html).
     */
    @JvmName("fuudbpsyquhlhpwh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the project in the CodeCatalyst space.
     * The following arguments are optional:
     */
    @JvmName("llhmwofclnbbhepq")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The name of the CodeCatalyst space.
     */
    @JvmName("pbwvrygmmdigvaak")
    public suspend fun spaceName(`value`: Output<String>) {
        this.spaceName = value
    }

    /**
     * @param value The description of the project. This description will be displayed to all users of the project. We recommend providing a brief description of the project and its intended purpose.
     */
    @JvmName("jehebmauiqeiqxcs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the source repository. For more information about name requirements, see [Quotas for source repositories](https://docs.aws.amazon.com/codecatalyst/latest/userguide/source-quotas.html).
     */
    @JvmName("ljemgafguyuarptx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the project in the CodeCatalyst space.
     * The following arguments are optional:
     */
    @JvmName("mwiwnejllktoldij")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The name of the CodeCatalyst space.
     */
    @JvmName("cwsyfxagescqumkp")
    public suspend fun spaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceName = mapped
    }

    internal fun build(): SourceRepositoryArgs = SourceRepositoryArgs(
        description = description,
        name = name,
        projectName = projectName,
        spaceName = spaceName,
    )
}
