@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecatalyst.kotlin.inputs

import com.pulumi.aws.codecatalyst.inputs.DevEnvironmentIdesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the IDE. Valid values include Cloud9, IntelliJ, PyCharm, GoLand, and VSCode.
 * @property runtime A link to the IDE runtime image. This parameter is not required if the name is VSCode. Values of the runtime can be for example public.ecr.aws/jetbrains/py,public.ecr.aws/jetbrains/go
 */
public data class DevEnvironmentIdesArgs(
    public val name: Output<String>? = null,
    public val runtime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codecatalyst.inputs.DevEnvironmentIdesArgs> {
    override fun toJava(): com.pulumi.aws.codecatalyst.inputs.DevEnvironmentIdesArgs =
        com.pulumi.aws.codecatalyst.inputs.DevEnvironmentIdesArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .runtime(runtime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DevEnvironmentIdesArgs].
 */
@PulumiTagMarker
public class DevEnvironmentIdesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var runtime: Output<String>? = null

    /**
     * @param value The name of the IDE. Valid values include Cloud9, IntelliJ, PyCharm, GoLand, and VSCode.
     */
    @JvmName("sjcclfheceoxvrtf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A link to the IDE runtime image. This parameter is not required if the name is VSCode. Values of the runtime can be for example public.ecr.aws/jetbrains/py,public.ecr.aws/jetbrains/go
     */
    @JvmName("duiajrihbpbfvmge")
    public suspend fun runtime(`value`: Output<String>) {
        this.runtime = value
    }

    /**
     * @param value The name of the IDE. Valid values include Cloud9, IntelliJ, PyCharm, GoLand, and VSCode.
     */
    @JvmName("svqvmhyhcdukjuij")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A link to the IDE runtime image. This parameter is not required if the name is VSCode. Values of the runtime can be for example public.ecr.aws/jetbrains/py,public.ecr.aws/jetbrains/go
     */
    @JvmName("trqdedjmysxvtlxu")
    public suspend fun runtime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    internal fun build(): DevEnvironmentIdesArgs = DevEnvironmentIdesArgs(
        name = name,
        runtime = runtime,
    )
}
