@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecatalyst.kotlin.inputs

import com.pulumi.aws.codecatalyst.inputs.DevEnvironmentPersistentStorageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property size The size of the persistent storage in gigabytes (specifically GiB). Valid values for storage are based on memory sizes in 16GB increments. Valid values are 16, 32, and 64.
 */
public data class DevEnvironmentPersistentStorageArgs(
    public val size: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.codecatalyst.inputs.DevEnvironmentPersistentStorageArgs> {
    override fun toJava(): com.pulumi.aws.codecatalyst.inputs.DevEnvironmentPersistentStorageArgs =
        com.pulumi.aws.codecatalyst.inputs.DevEnvironmentPersistentStorageArgs.builder()
            .size(size.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DevEnvironmentPersistentStorageArgs].
 */
@PulumiTagMarker
public class DevEnvironmentPersistentStorageArgsBuilder internal constructor() {
    private var size: Output<Int>? = null

    /**
     * @param value The size of the persistent storage in gigabytes (specifically GiB). Valid values for storage are based on memory sizes in 16GB increments. Valid values are 16, 32, and 64.
     */
    @JvmName("tnbtyqhecjgbwjbe")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The size of the persistent storage in gigabytes (specifically GiB). Valid values for storage are based on memory sizes in 16GB increments. Valid values are 16, 32, and 64.
     */
    @JvmName("gncrtxqetdkcsvvt")
    public suspend fun size(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    internal fun build(): DevEnvironmentPersistentStorageArgs = DevEnvironmentPersistentStorageArgs(
        size = size ?: throw PulumiNullFieldException("size"),
    )
}
