@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecatalyst.kotlin.inputs

import com.pulumi.aws.codecatalyst.inputs.GetDevEnvironmentRepository.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property branchName
 * @property repositoryName
 */
public data class GetDevEnvironmentRepository(
    public val branchName: String,
    public val repositoryName: String,
) : ConvertibleToJava<com.pulumi.aws.codecatalyst.inputs.GetDevEnvironmentRepository> {
    override fun toJava(): com.pulumi.aws.codecatalyst.inputs.GetDevEnvironmentRepository =
        com.pulumi.aws.codecatalyst.inputs.GetDevEnvironmentRepository.builder()
            .branchName(branchName.let({ args0 -> args0 }))
            .repositoryName(repositoryName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDevEnvironmentRepository].
 */
@PulumiTagMarker
public class GetDevEnvironmentRepositoryBuilder internal constructor() {
    private var branchName: String? = null

    private var repositoryName: String? = null

    /**
     * @param value
     */
    @JvmName("moxjoxjoufgqoohs")
    public suspend fun branchName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.branchName = mapped
    }

    /**
     * @param value
     */
    @JvmName("objbamnwmvhisofh")
    public suspend fun repositoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.repositoryName = mapped
    }

    internal fun build(): GetDevEnvironmentRepository = GetDevEnvironmentRepository(
        branchName = branchName ?: throw PulumiNullFieldException("branchName"),
        repositoryName = repositoryName ?: throw PulumiNullFieldException("repositoryName"),
    )
}
