@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecatalyst.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDevEnvironment.
 * @property alias The user-specified alias for the Dev Environment.
 * @property creatorId The system-generated unique ID of the user who created the Dev Environment.
 * @property envId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ides Information about the integrated development environment (IDE) configured for a Dev Environment.
 * @property inactivityTimeoutMinutes The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
 * @property instanceType The Amazon EC2 instace type to use for the Dev Environment.
 * @property lastUpdatedTime The time when the Dev Environment was last updated, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
 * @property persistentStorages Information about the amount of storage allocated to the Dev Environment.
 * @property projectName
 * @property repositories The source repository that contains the branch to clone into the Dev Environment.
 * @property spaceName
 * @property status The current status of the Dev Environment. From: PENDING | RUNNING | STARTING | STOPPING | STOPPED | FAILED | DELETING | DELETED.
 * @property statusReason The reason for the status.
 * @property tags
 */
public data class GetDevEnvironmentResult(
    public val alias: String? = null,
    public val creatorId: String? = null,
    public val envId: String,
    public val id: String,
    public val ides: List<GetDevEnvironmentIde>,
    public val inactivityTimeoutMinutes: Int,
    public val instanceType: String,
    public val lastUpdatedTime: String,
    public val persistentStorages: List<GetDevEnvironmentPersistentStorage>,
    public val projectName: String,
    public val repositories: List<GetDevEnvironmentRepository>? = null,
    public val spaceName: String,
    public val status: String,
    public val statusReason: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codecatalyst.outputs.GetDevEnvironmentResult):
            GetDevEnvironmentResult = GetDevEnvironmentResult(
            alias = javaType.alias().map({ args0 -> args0 }).orElse(null),
            creatorId = javaType.creatorId().map({ args0 -> args0 }).orElse(null),
            envId = javaType.envId(),
            id = javaType.id(),
            ides = javaType.ides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codecatalyst.kotlin.outputs.GetDevEnvironmentIde.Companion.toKotlin(args0)
                })
            }),
            inactivityTimeoutMinutes = javaType.inactivityTimeoutMinutes(),
            instanceType = javaType.instanceType(),
            lastUpdatedTime = javaType.lastUpdatedTime(),
            persistentStorages = javaType.persistentStorages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codecatalyst.kotlin.outputs.GetDevEnvironmentPersistentStorage.Companion.toKotlin(args0)
                })
            }),
            projectName = javaType.projectName(),
            repositories = javaType.repositories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codecatalyst.kotlin.outputs.GetDevEnvironmentRepository.Companion.toKotlin(args0)
                })
            }),
            spaceName = javaType.spaceName(),
            status = javaType.status(),
            statusReason = javaType.statusReason(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
