@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApprovalRuleTemplate].
 */
@PulumiTagMarker
public class ApprovalRuleTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApprovalRuleTemplateArgs = ApprovalRuleTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApprovalRuleTemplateArgsBuilder.() -> Unit) {
        val builder = ApprovalRuleTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ApprovalRuleTemplate {
        val builtJavaResource = com.pulumi.aws.codecommit.ApprovalRuleTemplate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApprovalRuleTemplate(builtJavaResource)
    }
}

/**
 * Provides a CodeCommit Approval Rule Template Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecommit.ApprovalRuleTemplate;
 * import com.pulumi.aws.codecommit.ApprovalRuleTemplateArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ApprovalRuleTemplate("example", ApprovalRuleTemplateArgs.builder()
 *             .description("This is an example approval rule template")
 *             .content(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2018-11-08"),
 *                     jsonProperty("DestinationReferences", jsonArray("refs/heads/master")),
 *                     jsonProperty("Statements", jsonArray(jsonObject(
 *                         jsonProperty("Type", "Approvers"),
 *                         jsonProperty("NumberOfApprovalsNeeded", 2),
 *                         jsonProperty("ApprovalPoolMembers", jsonArray("arn:aws:sts::123456789012:assumed-role/CodeCommitReview/*"))
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeCommit approval rule templates using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:codecommit/approvalRuleTemplate:ApprovalRuleTemplate imported ExistingApprovalRuleTemplateName
 * ```
 * */
 */
public class ApprovalRuleTemplate internal constructor(
    override val javaResource: com.pulumi.aws.codecommit.ApprovalRuleTemplate,
) : KotlinCustomResource(javaResource, ApprovalRuleTemplateMapper) {
    /**
     * The ID of the approval rule template
     */
    public val approvalRuleTemplateId: Output<String>
        get() = javaResource.approvalRuleTemplateId().applyValue({ args0 -> args0 })

    /**
     * The content of the approval rule template. Maximum of 3000 characters.
     */
    public val content: Output<String>
        get() = javaResource.content().applyValue({ args0 -> args0 })

    /**
     * The date the approval rule template was created, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * The description of the approval rule template. Maximum of 1000 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The date the approval rule template was most recently changed, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    public val lastModifiedDate: Output<String>
        get() = javaResource.lastModifiedDate().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule template.
     */
    public val lastModifiedUser: Output<String>
        get() = javaResource.lastModifiedUser().applyValue({ args0 -> args0 })

    /**
     * The name for the approval rule template. Maximum of 100 characters.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The SHA-256 hash signature for the content of the approval rule template.
     */
    public val ruleContentSha256: Output<String>
        get() = javaResource.ruleContentSha256().applyValue({ args0 -> args0 })
}

public object ApprovalRuleTemplateMapper : ResourceMapper<ApprovalRuleTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codecommit.ApprovalRuleTemplate::class == javaResource::class

    override fun map(javaResource: Resource): ApprovalRuleTemplate = ApprovalRuleTemplate(
        javaResource
            as com.pulumi.aws.codecommit.ApprovalRuleTemplate,
    )
}

/**
 * @see [ApprovalRuleTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApprovalRuleTemplate].
 */
public suspend fun approvalRuleTemplate(
    name: String,
    block: suspend ApprovalRuleTemplateResourceBuilder.() -> Unit,
): ApprovalRuleTemplate {
    val builder = ApprovalRuleTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApprovalRuleTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun approvalRuleTemplate(name: String): ApprovalRuleTemplate {
    val builder = ApprovalRuleTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
