@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin

import com.pulumi.aws.codecommit.ApprovalRuleTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CodeCommit Approval Rule Template Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecommit.ApprovalRuleTemplate;
 * import com.pulumi.aws.codecommit.ApprovalRuleTemplateArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ApprovalRuleTemplate("example", ApprovalRuleTemplateArgs.builder()
 *             .description("This is an example approval rule template")
 *             .content(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2018-11-08"),
 *                     jsonProperty("DestinationReferences", jsonArray("refs/heads/master")),
 *                     jsonProperty("Statements", jsonArray(jsonObject(
 *                         jsonProperty("Type", "Approvers"),
 *                         jsonProperty("NumberOfApprovalsNeeded", 2),
 *                         jsonProperty("ApprovalPoolMembers", jsonArray("arn:aws:sts::123456789012:assumed-role/CodeCommitReview/*"))
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeCommit approval rule templates using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:codecommit/approvalRuleTemplate:ApprovalRuleTemplate imported ExistingApprovalRuleTemplateName
 * ```
 * @property content The content of the approval rule template. Maximum of 3000 characters.
 * @property description The description of the approval rule template. Maximum of 1000 characters.
 * @property name The name for the approval rule template. Maximum of 100 characters.
 * */
 */
public data class ApprovalRuleTemplateArgs(
    public val content: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codecommit.ApprovalRuleTemplateArgs> {
    override fun toJava(): com.pulumi.aws.codecommit.ApprovalRuleTemplateArgs =
        com.pulumi.aws.codecommit.ApprovalRuleTemplateArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApprovalRuleTemplateArgs].
 */
@PulumiTagMarker
public class ApprovalRuleTemplateArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The content of the approval rule template. Maximum of 3000 characters.
     */
    @JvmName("fyxrlyxtbsepiscu")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The description of the approval rule template. Maximum of 1000 characters.
     */
    @JvmName("xyfttxtcyyucakgr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name for the approval rule template. Maximum of 100 characters.
     */
    @JvmName("kheqeekovrwbdfeo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The content of the approval rule template. Maximum of 3000 characters.
     */
    @JvmName("uxkokujxjsiblbvm")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The description of the approval rule template. Maximum of 1000 characters.
     */
    @JvmName("gcchnyhqpefqrpvp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name for the approval rule template. Maximum of 100 characters.
     */
    @JvmName("igrfuupesjkyetyi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ApprovalRuleTemplateArgs = ApprovalRuleTemplateArgs(
        content = content,
        description = description,
        name = name,
    )
}
