@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApprovalRuleTemplateAssociation].
 */
@PulumiTagMarker
public class ApprovalRuleTemplateAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApprovalRuleTemplateAssociationArgs = ApprovalRuleTemplateAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApprovalRuleTemplateAssociationArgsBuilder.() -> Unit) {
        val builder = ApprovalRuleTemplateAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ApprovalRuleTemplateAssociation {
        val builtJavaResource =
            com.pulumi.aws.codecommit.ApprovalRuleTemplateAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApprovalRuleTemplateAssociation(builtJavaResource)
    }
}

/**
 * Associates a CodeCommit Approval Rule Template with a Repository.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecommit.ApprovalRuleTemplateAssociation;
 * import com.pulumi.aws.codecommit.ApprovalRuleTemplateAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ApprovalRuleTemplateAssociation("example", ApprovalRuleTemplateAssociationArgs.builder()
 *             .approvalRuleTemplateName(aws_codecommit_approval_rule_template.example().name())
 *             .repositoryName(aws_codecommit_repository.example().repository_name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeCommit approval rule template associations using the `approval_rule_template_name` and `repository_name` separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:codecommit/approvalRuleTemplateAssociation:ApprovalRuleTemplateAssociation example approver-rule-for-example,MyExampleRepo
 * ```
 *
 */
public class ApprovalRuleTemplateAssociation internal constructor(
    override val javaResource: com.pulumi.aws.codecommit.ApprovalRuleTemplateAssociation,
) : KotlinCustomResource(javaResource, ApprovalRuleTemplateAssociationMapper) {
    /**
     * The name for the approval rule template.
     */
    public val approvalRuleTemplateName: Output<String>
        get() = javaResource.approvalRuleTemplateName().applyValue({ args0 -> args0 })

    /**
     * The name of the repository that you want to associate with the template.
     */
    public val repositoryName: Output<String>
        get() = javaResource.repositoryName().applyValue({ args0 -> args0 })
}

public object ApprovalRuleTemplateAssociationMapper :
    ResourceMapper<ApprovalRuleTemplateAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codecommit.ApprovalRuleTemplateAssociation::class == javaResource::class

    override fun map(javaResource: Resource): ApprovalRuleTemplateAssociation =
        ApprovalRuleTemplateAssociation(
            javaResource as
                com.pulumi.aws.codecommit.ApprovalRuleTemplateAssociation,
        )
}

/**
 * @see [ApprovalRuleTemplateAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApprovalRuleTemplateAssociation].
 */
public suspend fun approvalRuleTemplateAssociation(
    name: String,
    block: suspend ApprovalRuleTemplateAssociationResourceBuilder.() -> Unit,
):
    ApprovalRuleTemplateAssociation {
    val builder = ApprovalRuleTemplateAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApprovalRuleTemplateAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun approvalRuleTemplateAssociation(name: String): ApprovalRuleTemplateAssociation {
    val builder = ApprovalRuleTemplateAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
