@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin

import com.pulumi.aws.codecommit.CodecommitFunctions.getApprovalRuleTemplatePlain
import com.pulumi.aws.codecommit.CodecommitFunctions.getRepositoryPlain
import com.pulumi.aws.codecommit.kotlin.inputs.GetApprovalRuleTemplatePlainArgs
import com.pulumi.aws.codecommit.kotlin.inputs.GetApprovalRuleTemplatePlainArgsBuilder
import com.pulumi.aws.codecommit.kotlin.inputs.GetRepositoryPlainArgs
import com.pulumi.aws.codecommit.kotlin.inputs.GetRepositoryPlainArgsBuilder
import com.pulumi.aws.codecommit.kotlin.outputs.GetApprovalRuleTemplateResult
import com.pulumi.aws.codecommit.kotlin.outputs.GetRepositoryResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.codecommit.kotlin.outputs.GetApprovalRuleTemplateResult.Companion.toKotlin as getApprovalRuleTemplateResultToKotlin
import com.pulumi.aws.codecommit.kotlin.outputs.GetRepositoryResult.Companion.toKotlin as getRepositoryResultToKotlin

public object CodecommitFunctions {
    /**
     * Provides details about a specific CodeCommit Approval Rule Template.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.codecommit.CodecommitFunctions;
     * import com.pulumi.aws.codecommit.inputs.GetApprovalRuleTemplateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CodecommitFunctions.getApprovalRuleTemplate(GetApprovalRuleTemplateArgs.builder()
     *             .name("MyExampleApprovalRuleTemplate")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getApprovalRuleTemplate.
     * @return A collection of values returned by getApprovalRuleTemplate.
     */
    public suspend fun getApprovalRuleTemplate(argument: GetApprovalRuleTemplatePlainArgs):
        GetApprovalRuleTemplateResult =
        getApprovalRuleTemplateResultToKotlin(getApprovalRuleTemplatePlain(argument.toJava()).await())

    /**
     * @see [getApprovalRuleTemplate].
     * @param name Name for the approval rule template. This needs to be less than 100 characters.
     * @return A collection of values returned by getApprovalRuleTemplate.
     */
    public suspend fun getApprovalRuleTemplate(name: String): GetApprovalRuleTemplateResult {
        val argument = GetApprovalRuleTemplatePlainArgs(
            name = name,
        )
        return getApprovalRuleTemplateResultToKotlin(getApprovalRuleTemplatePlain(argument.toJava()).await())
    }

    /**
     * @see [getApprovalRuleTemplate].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;codecommit&#46;kotlin&#46;inputs&#46;GetApprovalRuleTemplatePlainArgs].
     * @return A collection of values returned by getApprovalRuleTemplate.
     */
    public suspend
    fun getApprovalRuleTemplate(argument: suspend GetApprovalRuleTemplatePlainArgsBuilder.() -> Unit):
        GetApprovalRuleTemplateResult {
        val builder = GetApprovalRuleTemplatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApprovalRuleTemplateResultToKotlin(getApprovalRuleTemplatePlain(builtArgument.toJava()).await())
    }

    /**
     * The CodeCommit Repository data source allows the ARN, Repository ID, Repository URL for HTTP and Repository URL for SSH to be retrieved for an CodeCommit repository.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.codecommit.CodecommitFunctions;
     * import com.pulumi.aws.codecommit.inputs.GetRepositoryArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = CodecommitFunctions.getRepository(GetRepositoryArgs.builder()
     *             .repositoryName("MyTestRepository")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRepository.
     * @return A collection of values returned by getRepository.
     */
    public suspend fun getRepository(argument: GetRepositoryPlainArgs): GetRepositoryResult =
        getRepositoryResultToKotlin(getRepositoryPlain(argument.toJava()).await())

    /**
     * @see [getRepository].
     * @param repositoryName Name for the repository. This needs to be less than 100 characters.
     * @return A collection of values returned by getRepository.
     */
    public suspend fun getRepository(repositoryName: String): GetRepositoryResult {
        val argument = GetRepositoryPlainArgs(
            repositoryName = repositoryName,
        )
        return getRepositoryResultToKotlin(getRepositoryPlain(argument.toJava()).await())
    }

    /**
     * @see [getRepository].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;codecommit&#46;kotlin&#46;inputs&#46;GetRepositoryPlainArgs].
     * @return A collection of values returned by getRepository.
     */
    public suspend fun getRepository(argument: suspend GetRepositoryPlainArgsBuilder.() -> Unit):
        GetRepositoryResult {
        val builder = GetRepositoryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRepositoryResultToKotlin(getRepositoryPlain(builtArgument.toJava()).await())
    }
}
