@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Repository].
 */
@PulumiTagMarker
public class RepositoryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RepositoryArgs = RepositoryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RepositoryArgsBuilder.() -> Unit) {
        val builder = RepositoryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Repository {
        val builtJavaResource = com.pulumi.aws.codecommit.Repository(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Repository(builtJavaResource)
    }
}

/**
 * Provides a CodeCommit Repository Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecommit.Repository;
 * import com.pulumi.aws.codecommit.RepositoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Repository("test", RepositoryArgs.builder()
 *             .description("This is the Sample App Repository")
 *             .repositoryName("MyTestRepository")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeCommit repository using repository name. For example:
 * ```sh
 *  $ pulumi import aws:codecommit/repository:Repository imported ExistingRepo
 * ```
 *
 */
public class Repository internal constructor(
    override val javaResource: com.pulumi.aws.codecommit.Repository,
) : KotlinCustomResource(javaResource, RepositoryMapper) {
    /**
     * The ARN of the repository
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The URL to use for cloning the repository over HTTPS.
     */
    public val cloneUrlHttp: Output<String>
        get() = javaResource.cloneUrlHttp().applyValue({ args0 -> args0 })

    /**
     * The URL to use for cloning the repository over SSH.
     */
    public val cloneUrlSsh: Output<String>
        get() = javaResource.cloneUrlSsh().applyValue({ args0 -> args0 })

    /**
     * The default branch of the repository. The branch specified here needs to exist.
     */
    public val defaultBranch: Output<String>?
        get() = javaResource.defaultBranch().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the repository. This needs to be less than 1000 characters
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the repository
     */
    public val repositoryId: Output<String>
        get() = javaResource.repositoryId().applyValue({ args0 -> args0 })

    /**
     * The name for the repository. This needs to be less than 100 characters.
     */
    public val repositoryName: Output<String>
        get() = javaResource.repositoryName().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object RepositoryMapper : ResourceMapper<Repository> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codecommit.Repository::class == javaResource::class

    override fun map(javaResource: Resource): Repository = Repository(
        javaResource as
            com.pulumi.aws.codecommit.Repository,
    )
}

/**
 * @see [Repository].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Repository].
 */
public suspend fun repository(name: String, block: suspend RepositoryResourceBuilder.() -> Unit):
    Repository {
    val builder = RepositoryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Repository].
 * @param name The _unique_ name of the resulting resource.
 */
public fun repository(name: String): Repository {
    val builder = RepositoryResourceBuilder()
    builder.name(name)
    return builder.build()
}
