@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin

import com.pulumi.aws.codecommit.RepositoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodeCommit Repository Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecommit.Repository;
 * import com.pulumi.aws.codecommit.RepositoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Repository("test", RepositoryArgs.builder()
 *             .description("This is the Sample App Repository")
 *             .repositoryName("MyTestRepository")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeCommit repository using repository name. For example:
 * ```sh
 *  $ pulumi import aws:codecommit/repository:Repository imported ExistingRepo
 * ```
 * @property defaultBranch The default branch of the repository. The branch specified here needs to exist.
 * @property description The description of the repository. This needs to be less than 1000 characters
 * @property repositoryName The name for the repository. This needs to be less than 100 characters.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RepositoryArgs(
    public val defaultBranch: Output<String>? = null,
    public val description: Output<String>? = null,
    public val repositoryName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codecommit.RepositoryArgs> {
    override fun toJava(): com.pulumi.aws.codecommit.RepositoryArgs =
        com.pulumi.aws.codecommit.RepositoryArgs.builder()
            .defaultBranch(defaultBranch?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .repositoryName(repositoryName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RepositoryArgs].
 */
@PulumiTagMarker
public class RepositoryArgsBuilder internal constructor() {
    private var defaultBranch: Output<String>? = null

    private var description: Output<String>? = null

    private var repositoryName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The default branch of the repository. The branch specified here needs to exist.
     */
    @JvmName("rgabxlwecrtbrvex")
    public suspend fun defaultBranch(`value`: Output<String>) {
        this.defaultBranch = value
    }

    /**
     * @param value The description of the repository. This needs to be less than 1000 characters
     */
    @JvmName("pfswumsinnoymrec")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name for the repository. This needs to be less than 100 characters.
     */
    @JvmName("cjkrtlchosylcfvd")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rdnuunogexmvuxrv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The default branch of the repository. The branch specified here needs to exist.
     */
    @JvmName("emwhsrfoqxomerpl")
    public suspend fun defaultBranch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultBranch = mapped
    }

    /**
     * @param value The description of the repository. This needs to be less than 1000 characters
     */
    @JvmName("fuqvcgkrjixkffhm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name for the repository. This needs to be less than 100 characters.
     */
    @JvmName("ntqkmejcuvasigmr")
    public suspend fun repositoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("houfgcedrsrldmfd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("milcyedkilohsupa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RepositoryArgs = RepositoryArgs(
        defaultBranch = defaultBranch,
        description = description,
        repositoryName = repositoryName,
        tags = tags,
    )
}
