@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin

import com.pulumi.aws.codecommit.kotlin.outputs.TriggerTrigger
import com.pulumi.aws.codecommit.kotlin.outputs.TriggerTrigger.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Trigger].
 */
@PulumiTagMarker
public class TriggerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TriggerArgs = TriggerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TriggerArgsBuilder.() -> Unit) {
        val builder = TriggerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Trigger {
        val builtJavaResource = com.pulumi.aws.codecommit.Trigger(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Trigger(builtJavaResource)
    }
}

/**
 * Provides a CodeCommit Trigger Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecommit.Repository;
 * import com.pulumi.aws.codecommit.RepositoryArgs;
 * import com.pulumi.aws.codecommit.Trigger;
 * import com.pulumi.aws.codecommit.TriggerArgs;
 * import com.pulumi.aws.codecommit.inputs.TriggerTriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testRepository = new Repository("testRepository", RepositoryArgs.builder()
 *             .repositoryName("test")
 *             .build());
 *         var testTrigger = new Trigger("testTrigger", TriggerArgs.builder()
 *             .repositoryName(testRepository.repositoryName())
 *             .triggers(TriggerTriggerArgs.builder()
 *                 .name("all")
 *                 .events("all")
 *                 .destinationArn(aws_sns_topic.test().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 */
public class Trigger internal constructor(
    override val javaResource: com.pulumi.aws.codecommit.Trigger,
) : KotlinCustomResource(javaResource, TriggerMapper) {
    /**
     * System-generated unique identifier.
     */
    public val configurationId: Output<String>
        get() = javaResource.configurationId().applyValue({ args0 -> args0 })

    /**
     * The name for the repository. This needs to be less than 100 characters.
     */
    public val repositoryName: Output<String>
        get() = javaResource.repositoryName().applyValue({ args0 -> args0 })

    /**
     * The name of the trigger.
     */
    public val triggers: Output<List<TriggerTrigger>>
        get() = javaResource.triggers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object TriggerMapper : ResourceMapper<Trigger> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codecommit.Trigger::class == javaResource::class

    override fun map(javaResource: Resource): Trigger = Trigger(
        javaResource as
            com.pulumi.aws.codecommit.Trigger,
    )
}

/**
 * @see [Trigger].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Trigger].
 */
public suspend fun trigger(name: String, block: suspend TriggerResourceBuilder.() -> Unit):
    Trigger {
    val builder = TriggerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Trigger].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trigger(name: String): Trigger {
    val builder = TriggerResourceBuilder()
    builder.name(name)
    return builder.build()
}
