@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin

import com.pulumi.aws.codecommit.TriggerArgs.builder
import com.pulumi.aws.codecommit.kotlin.inputs.TriggerTriggerArgs
import com.pulumi.aws.codecommit.kotlin.inputs.TriggerTriggerArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a CodeCommit Trigger Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecommit.Repository;
 * import com.pulumi.aws.codecommit.RepositoryArgs;
 * import com.pulumi.aws.codecommit.Trigger;
 * import com.pulumi.aws.codecommit.TriggerArgs;
 * import com.pulumi.aws.codecommit.inputs.TriggerTriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testRepository = new Repository("testRepository", RepositoryArgs.builder()
 *             .repositoryName("test")
 *             .build());
 *         var testTrigger = new Trigger("testTrigger", TriggerArgs.builder()
 *             .repositoryName(testRepository.repositoryName())
 *             .triggers(TriggerTriggerArgs.builder()
 *                 .name("all")
 *                 .events("all")
 *                 .destinationArn(aws_sns_topic.test().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * @property repositoryName The name for the repository. This needs to be less than 100 characters.
 * @property triggers The name of the trigger.
 */
public data class TriggerArgs(
    public val repositoryName: Output<String>? = null,
    public val triggers: Output<List<TriggerTriggerArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codecommit.TriggerArgs> {
    override fun toJava(): com.pulumi.aws.codecommit.TriggerArgs =
        com.pulumi.aws.codecommit.TriggerArgs.builder()
            .repositoryName(repositoryName?.applyValue({ args0 -> args0 }))
            .triggers(
                triggers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TriggerArgs].
 */
@PulumiTagMarker
public class TriggerArgsBuilder internal constructor() {
    private var repositoryName: Output<String>? = null

    private var triggers: Output<List<TriggerTriggerArgs>>? = null

    /**
     * @param value The name for the repository. This needs to be less than 100 characters.
     */
    @JvmName("fwajljjhiqjhojub")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value The name of the trigger.
     */
    @JvmName("fcxrtgyhpcncswsq")
    public suspend fun triggers(`value`: Output<List<TriggerTriggerArgs>>) {
        this.triggers = value
    }

    @JvmName("ivrodpxexnryyjdv")
    public suspend fun triggers(vararg values: Output<TriggerTriggerArgs>) {
        this.triggers = Output.all(values.asList())
    }

    /**
     * @param values The name of the trigger.
     */
    @JvmName("gbfkspvpeaqdonkp")
    public suspend fun triggers(values: List<Output<TriggerTriggerArgs>>) {
        this.triggers = Output.all(values)
    }

    /**
     * @param value The name for the repository. This needs to be less than 100 characters.
     */
    @JvmName("kpswiikjixsmuvxs")
    public suspend fun repositoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    /**
     * @param value The name of the trigger.
     */
    @JvmName("kuxmetrsinhqssos")
    public suspend fun triggers(`value`: List<TriggerTriggerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    /**
     * @param argument The name of the trigger.
     */
    @JvmName("fpumfwalpovglsry")
    public suspend fun triggers(argument: List<suspend TriggerTriggerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TriggerTriggerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.triggers = mapped
    }

    /**
     * @param argument The name of the trigger.
     */
    @JvmName("cfgyvnsfetxvvqav")
    public suspend fun triggers(vararg argument: suspend TriggerTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TriggerTriggerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.triggers = mapped
    }

    /**
     * @param argument The name of the trigger.
     */
    @JvmName("ubnfuqmcqdfxyapq")
    public suspend fun triggers(argument: suspend TriggerTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TriggerTriggerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.triggers = mapped
    }

    /**
     * @param values The name of the trigger.
     */
    @JvmName("dhygtyxymyfsjymo")
    public suspend fun triggers(vararg values: TriggerTriggerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    internal fun build(): TriggerArgs = TriggerArgs(
        repositoryName = repositoryName,
        triggers = triggers,
    )
}
