@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin.inputs

import com.pulumi.aws.codecommit.inputs.GetApprovalRuleTemplatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getApprovalRuleTemplate.
 * @property name Name for the approval rule template. This needs to be less than 100 characters.
 */
public data class GetApprovalRuleTemplatePlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.codecommit.inputs.GetApprovalRuleTemplatePlainArgs> {
    override fun toJava(): com.pulumi.aws.codecommit.inputs.GetApprovalRuleTemplatePlainArgs =
        com.pulumi.aws.codecommit.inputs.GetApprovalRuleTemplatePlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApprovalRuleTemplatePlainArgs].
 */
@PulumiTagMarker
public class GetApprovalRuleTemplatePlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name for the approval rule template. This needs to be less than 100 characters.
     */
    @JvmName("slgwxuyljnlbmauc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetApprovalRuleTemplatePlainArgs = GetApprovalRuleTemplatePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
