@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getApprovalRuleTemplate.
 * @property approvalRuleTemplateId The ID of the approval rule template.
 * @property content Content of the approval rule template.
 * @property creationDate Date the approval rule template was created, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 * @property description Description of the approval rule template.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lastModifiedDate Date the approval rule template was most recently changed, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 * @property lastModifiedUser ARN of the user who made the most recent changes to the approval rule template.
 * @property name
 * @property ruleContentSha256 SHA-256 hash signature for the content of the approval rule template.
 */
public data class GetApprovalRuleTemplateResult(
    public val approvalRuleTemplateId: String,
    public val content: String,
    public val creationDate: String,
    public val description: String,
    public val id: String,
    public val lastModifiedDate: String,
    public val lastModifiedUser: String,
    public val name: String,
    public val ruleContentSha256: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codecommit.outputs.GetApprovalRuleTemplateResult):
            GetApprovalRuleTemplateResult = GetApprovalRuleTemplateResult(
            approvalRuleTemplateId = javaType.approvalRuleTemplateId(),
            content = javaType.content(),
            creationDate = javaType.creationDate(),
            description = javaType.description(),
            id = javaType.id(),
            lastModifiedDate = javaType.lastModifiedDate(),
            lastModifiedUser = javaType.lastModifiedUser(),
            name = javaType.name(),
            ruleContentSha256 = javaType.ruleContentSha256(),
        )
    }
}
