@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codecommit.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property branches The branches that will be included in the trigger configuration. If no branches   are specified, the trigger will apply to all branches.
 * @property customData Any custom data associated with the trigger that will be included in the information sent to the target of the trigger.
 * @property destinationArn The ARN of the resource that is the target for a trigger. For example, the ARN of a topic in Amazon Simple Notification Service (SNS).
 * @property events The repository events that will cause the trigger to run actions in another service, such as sending a notification through Amazon Simple Notification Service (SNS). If no events are specified, the trigger will run for all repository events. Event types include: `all`, `updateReference`, `createReference`, `deleteReference`.
 * @property name The name of the trigger.
 */
public data class TriggerTrigger(
    public val branches: List<String>? = null,
    public val customData: String? = null,
    public val destinationArn: String,
    public val events: List<String>,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codecommit.outputs.TriggerTrigger): TriggerTrigger =
            TriggerTrigger(
                branches = javaType.branches().map({ args0 -> args0 }),
                customData = javaType.customData().map({ args0 -> args0 }).orElse(null),
                destinationArn = javaType.destinationArn(),
                events = javaType.events().map({ args0 -> args0 }),
                name = javaType.name(),
            )
    }
}
