@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin

import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentConfigMinimumHealthyHosts
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentConfigTrafficRoutingConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentConfigMinimumHealthyHosts.Companion.toKotlin as deploymentConfigMinimumHealthyHostsToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentConfigTrafficRoutingConfig.Companion.toKotlin as deploymentConfigTrafficRoutingConfigToKotlin

/**
 * Builder for [DeploymentConfig].
 */
@PulumiTagMarker
public class DeploymentConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeploymentConfigArgs = DeploymentConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeploymentConfigArgsBuilder.() -> Unit) {
        val builder = DeploymentConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DeploymentConfig {
        val builtJavaResource = com.pulumi.aws.codedeploy.DeploymentConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DeploymentConfig(builtJavaResource)
    }
}

/**
 * Provides a CodeDeploy deployment config for an application
 * ## Example Usage
 * ### Server Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codedeploy.DeploymentConfig;
 * import com.pulumi.aws.codedeploy.DeploymentConfigArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentConfigMinimumHealthyHostsArgs;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupEc2TagFilterArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupTriggerConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAlarmConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fooDeploymentConfig = new DeploymentConfig("fooDeploymentConfig", DeploymentConfigArgs.builder()
 *             .deploymentConfigName("test-deployment-config")
 *             .minimumHealthyHosts(DeploymentConfigMinimumHealthyHostsArgs.builder()
 *                 .type("HOST_COUNT")
 *                 .value(2)
 *                 .build())
 *             .build());
 *         var fooDeploymentGroup = new DeploymentGroup("fooDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(aws_codedeploy_app.foo_app().name())
 *             .deploymentGroupName("bar")
 *             .serviceRoleArn(aws_iam_role.foo_role().arn())
 *             .deploymentConfigName(fooDeploymentConfig.id())
 *             .ec2TagFilters(DeploymentGroupEc2TagFilterArgs.builder()
 *                 .key("filterkey")
 *                 .type("KEY_AND_VALUE")
 *                 .value("filtervalue")
 *                 .build())
 *             .triggerConfigurations(DeploymentGroupTriggerConfigurationArgs.builder()
 *                 .triggerEvents("DeploymentFailure")
 *                 .triggerName("foo-trigger")
 *                 .triggerTargetArn("foo-topic-arn")
 *                 .build())
 *             .autoRollbackConfiguration(DeploymentGroupAutoRollbackConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .events("DEPLOYMENT_FAILURE")
 *                 .build())
 *             .alarmConfiguration(DeploymentGroupAlarmConfigurationArgs.builder()
 *                 .alarms("my-alarm-name")
 *                 .enabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Lambda Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codedeploy.DeploymentConfig;
 * import com.pulumi.aws.codedeploy.DeploymentConfigArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAlarmConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fooDeploymentConfig = new DeploymentConfig("fooDeploymentConfig", DeploymentConfigArgs.builder()
 *             .deploymentConfigName("test-deployment-config")
 *             .computePlatform("Lambda")
 *             .trafficRoutingConfig(DeploymentConfigTrafficRoutingConfigArgs.builder()
 *                 .type("TimeBasedLinear")
 *                 .timeBasedLinear(DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs.builder()
 *                     .interval(10)
 *                     .percentage(10)
 *                     .build())
 *                 .build())
 *             .build());
 *         var fooDeploymentGroup = new DeploymentGroup("fooDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(aws_codedeploy_app.foo_app().name())
 *             .deploymentGroupName("bar")
 *             .serviceRoleArn(aws_iam_role.foo_role().arn())
 *             .deploymentConfigName(fooDeploymentConfig.id())
 *             .autoRollbackConfiguration(DeploymentGroupAutoRollbackConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .events("DEPLOYMENT_STOP_ON_ALARM")
 *                 .build())
 *             .alarmConfiguration(DeploymentGroupAlarmConfigurationArgs.builder()
 *                 .alarms("my-alarm-name")
 *                 .enabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeDeploy Deployment Configurations using the `deployment_config_name`. For example:
 * ```sh
 *  $ pulumi import aws:codedeploy/deploymentConfig:DeploymentConfig example my-deployment-config
 * ```
 *
 */
public class DeploymentConfig internal constructor(
    override val javaResource: com.pulumi.aws.codedeploy.DeploymentConfig,
) : KotlinCustomResource(javaResource, DeploymentConfigMapper) {
    /**
     * The compute platform can be `Server`, `Lambda`, or `ECS`. Default is `Server`.
     */
    public val computePlatform: Output<String>?
        get() = javaResource.computePlatform().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The AWS Assigned deployment config id
     */
    public val deploymentConfigId: Output<String>
        get() = javaResource.deploymentConfigId().applyValue({ args0 -> args0 })

    /**
     * The name of the deployment config.
     */
    public val deploymentConfigName: Output<String>
        get() = javaResource.deploymentConfigName().applyValue({ args0 -> args0 })

    /**
     * A minimum_healthy_hosts block. Required for `Server` compute platform. Minimum Healthy Hosts are documented below.
     */
    public val minimumHealthyHosts: Output<DeploymentConfigMinimumHealthyHosts>?
        get() = javaResource.minimumHealthyHosts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deploymentConfigMinimumHealthyHostsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A traffic_routing_config block. Traffic Routing Config is documented below.
     */
    public val trafficRoutingConfig: Output<DeploymentConfigTrafficRoutingConfig>?
        get() = javaResource.trafficRoutingConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deploymentConfigTrafficRoutingConfigToKotlin(args0) })
            }).orElse(null)
        })
}

public object DeploymentConfigMapper : ResourceMapper<DeploymentConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codedeploy.DeploymentConfig::class == javaResource::class

    override fun map(javaResource: Resource): DeploymentConfig = DeploymentConfig(
        javaResource as
            com.pulumi.aws.codedeploy.DeploymentConfig,
    )
}

/**
 * @see [DeploymentConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DeploymentConfig].
 */
public suspend fun deploymentConfig(
    name: String,
    block: suspend DeploymentConfigResourceBuilder.() -> Unit,
): DeploymentConfig {
    val builder = DeploymentConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DeploymentConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deploymentConfig(name: String): DeploymentConfig {
    val builder = DeploymentConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
