@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin

import com.pulumi.aws.codedeploy.DeploymentConfigArgs.builder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentConfigMinimumHealthyHostsArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentConfigMinimumHealthyHostsArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentConfigTrafficRoutingConfigArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentConfigTrafficRoutingConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a CodeDeploy deployment config for an application
 * ## Example Usage
 * ### Server Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codedeploy.DeploymentConfig;
 * import com.pulumi.aws.codedeploy.DeploymentConfigArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentConfigMinimumHealthyHostsArgs;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupEc2TagFilterArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupTriggerConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAlarmConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fooDeploymentConfig = new DeploymentConfig("fooDeploymentConfig", DeploymentConfigArgs.builder()
 *             .deploymentConfigName("test-deployment-config")
 *             .minimumHealthyHosts(DeploymentConfigMinimumHealthyHostsArgs.builder()
 *                 .type("HOST_COUNT")
 *                 .value(2)
 *                 .build())
 *             .build());
 *         var fooDeploymentGroup = new DeploymentGroup("fooDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(aws_codedeploy_app.foo_app().name())
 *             .deploymentGroupName("bar")
 *             .serviceRoleArn(aws_iam_role.foo_role().arn())
 *             .deploymentConfigName(fooDeploymentConfig.id())
 *             .ec2TagFilters(DeploymentGroupEc2TagFilterArgs.builder()
 *                 .key("filterkey")
 *                 .type("KEY_AND_VALUE")
 *                 .value("filtervalue")
 *                 .build())
 *             .triggerConfigurations(DeploymentGroupTriggerConfigurationArgs.builder()
 *                 .triggerEvents("DeploymentFailure")
 *                 .triggerName("foo-trigger")
 *                 .triggerTargetArn("foo-topic-arn")
 *                 .build())
 *             .autoRollbackConfiguration(DeploymentGroupAutoRollbackConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .events("DEPLOYMENT_FAILURE")
 *                 .build())
 *             .alarmConfiguration(DeploymentGroupAlarmConfigurationArgs.builder()
 *                 .alarms("my-alarm-name")
 *                 .enabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Lambda Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codedeploy.DeploymentConfig;
 * import com.pulumi.aws.codedeploy.DeploymentConfigArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAlarmConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fooDeploymentConfig = new DeploymentConfig("fooDeploymentConfig", DeploymentConfigArgs.builder()
 *             .deploymentConfigName("test-deployment-config")
 *             .computePlatform("Lambda")
 *             .trafficRoutingConfig(DeploymentConfigTrafficRoutingConfigArgs.builder()
 *                 .type("TimeBasedLinear")
 *                 .timeBasedLinear(DeploymentConfigTrafficRoutingConfigTimeBasedLinearArgs.builder()
 *                     .interval(10)
 *                     .percentage(10)
 *                     .build())
 *                 .build())
 *             .build());
 *         var fooDeploymentGroup = new DeploymentGroup("fooDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(aws_codedeploy_app.foo_app().name())
 *             .deploymentGroupName("bar")
 *             .serviceRoleArn(aws_iam_role.foo_role().arn())
 *             .deploymentConfigName(fooDeploymentConfig.id())
 *             .autoRollbackConfiguration(DeploymentGroupAutoRollbackConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .events("DEPLOYMENT_STOP_ON_ALARM")
 *                 .build())
 *             .alarmConfiguration(DeploymentGroupAlarmConfigurationArgs.builder()
 *                 .alarms("my-alarm-name")
 *                 .enabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeDeploy Deployment Configurations using the `deployment_config_name`. For example:
 * ```sh
 *  $ pulumi import aws:codedeploy/deploymentConfig:DeploymentConfig example my-deployment-config
 * ```
 * @property computePlatform The compute platform can be `Server`, `Lambda`, or `ECS`. Default is `Server`.
 * @property deploymentConfigName The name of the deployment config.
 * @property minimumHealthyHosts A minimum_healthy_hosts block. Required for `Server` compute platform. Minimum Healthy Hosts are documented below.
 * @property trafficRoutingConfig A traffic_routing_config block. Traffic Routing Config is documented below.
 */
public data class DeploymentConfigArgs(
    public val computePlatform: Output<String>? = null,
    public val deploymentConfigName: Output<String>? = null,
    public val minimumHealthyHosts: Output<DeploymentConfigMinimumHealthyHostsArgs>? = null,
    public val trafficRoutingConfig: Output<DeploymentConfigTrafficRoutingConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.codedeploy.DeploymentConfigArgs> {
    override fun toJava(): com.pulumi.aws.codedeploy.DeploymentConfigArgs =
        com.pulumi.aws.codedeploy.DeploymentConfigArgs.builder()
            .computePlatform(computePlatform?.applyValue({ args0 -> args0 }))
            .deploymentConfigName(deploymentConfigName?.applyValue({ args0 -> args0 }))
            .minimumHealthyHosts(
                minimumHealthyHosts?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .trafficRoutingConfig(
                trafficRoutingConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DeploymentConfigArgs].
 */
@PulumiTagMarker
public class DeploymentConfigArgsBuilder internal constructor() {
    private var computePlatform: Output<String>? = null

    private var deploymentConfigName: Output<String>? = null

    private var minimumHealthyHosts: Output<DeploymentConfigMinimumHealthyHostsArgs>? = null

    private var trafficRoutingConfig: Output<DeploymentConfigTrafficRoutingConfigArgs>? = null

    /**
     * @param value The compute platform can be `Server`, `Lambda`, or `ECS`. Default is `Server`.
     */
    @JvmName("euskdknnsfthgadg")
    public suspend fun computePlatform(`value`: Output<String>) {
        this.computePlatform = value
    }

    /**
     * @param value The name of the deployment config.
     */
    @JvmName("snlepxkljjxrbhfk")
    public suspend fun deploymentConfigName(`value`: Output<String>) {
        this.deploymentConfigName = value
    }

    /**
     * @param value A minimum_healthy_hosts block. Required for `Server` compute platform. Minimum Healthy Hosts are documented below.
     */
    @JvmName("asjyjmervoymthqm")
    public suspend fun minimumHealthyHosts(`value`: Output<DeploymentConfigMinimumHealthyHostsArgs>) {
        this.minimumHealthyHosts = value
    }

    /**
     * @param value A traffic_routing_config block. Traffic Routing Config is documented below.
     */
    @JvmName("kxgtkfmihnsesaeo")
    public suspend
    fun trafficRoutingConfig(`value`: Output<DeploymentConfigTrafficRoutingConfigArgs>) {
        this.trafficRoutingConfig = value
    }

    /**
     * @param value The compute platform can be `Server`, `Lambda`, or `ECS`. Default is `Server`.
     */
    @JvmName("rcjphebhxjyruaav")
    public suspend fun computePlatform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computePlatform = mapped
    }

    /**
     * @param value The name of the deployment config.
     */
    @JvmName("dyaoyhdlqipivrio")
    public suspend fun deploymentConfigName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentConfigName = mapped
    }

    /**
     * @param value A minimum_healthy_hosts block. Required for `Server` compute platform. Minimum Healthy Hosts are documented below.
     */
    @JvmName("dpajcanxbtmeasok")
    public suspend fun minimumHealthyHosts(`value`: DeploymentConfigMinimumHealthyHostsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumHealthyHosts = mapped
    }

    /**
     * @param argument A minimum_healthy_hosts block. Required for `Server` compute platform. Minimum Healthy Hosts are documented below.
     */
    @JvmName("ggbbvpsrxregmswo")
    public suspend
    fun minimumHealthyHosts(argument: suspend DeploymentConfigMinimumHealthyHostsArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentConfigMinimumHealthyHostsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.minimumHealthyHosts = mapped
    }

    /**
     * @param value A traffic_routing_config block. Traffic Routing Config is documented below.
     */
    @JvmName("usrxttumoekhaoyy")
    public suspend fun trafficRoutingConfig(`value`: DeploymentConfigTrafficRoutingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficRoutingConfig = mapped
    }

    /**
     * @param argument A traffic_routing_config block. Traffic Routing Config is documented below.
     */
    @JvmName("xewflxkpavpwjclj")
    public suspend
    fun trafficRoutingConfig(argument: suspend DeploymentConfigTrafficRoutingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentConfigTrafficRoutingConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.trafficRoutingConfig = mapped
    }

    internal fun build(): DeploymentConfigArgs = DeploymentConfigArgs(
        computePlatform = computePlatform,
        deploymentConfigName = deploymentConfigName,
        minimumHealthyHosts = minimumHealthyHosts,
        trafficRoutingConfig = trafficRoutingConfig,
    )
}
