@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin

import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupAlarmConfiguration
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupAutoRollbackConfiguration
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupBlueGreenDeploymentConfig
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupDeploymentStyle
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupEc2TagFilter
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupEc2TagSet
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupEcsService
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupLoadBalancerInfo
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupOnPremisesInstanceTagFilter
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupTriggerConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupAlarmConfiguration.Companion.toKotlin as deploymentGroupAlarmConfigurationToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupAutoRollbackConfiguration.Companion.toKotlin as deploymentGroupAutoRollbackConfigurationToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupBlueGreenDeploymentConfig.Companion.toKotlin as deploymentGroupBlueGreenDeploymentConfigToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupDeploymentStyle.Companion.toKotlin as deploymentGroupDeploymentStyleToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupEc2TagFilter.Companion.toKotlin as deploymentGroupEc2TagFilterToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupEc2TagSet.Companion.toKotlin as deploymentGroupEc2TagSetToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupEcsService.Companion.toKotlin as deploymentGroupEcsServiceToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupLoadBalancerInfo.Companion.toKotlin as deploymentGroupLoadBalancerInfoToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupOnPremisesInstanceTagFilter.Companion.toKotlin as deploymentGroupOnPremisesInstanceTagFilterToKotlin
import com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupTriggerConfiguration.Companion.toKotlin as deploymentGroupTriggerConfigurationToKotlin

/**
 * Builder for [DeploymentGroup].
 */
@PulumiTagMarker
public class DeploymentGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeploymentGroupArgs = DeploymentGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeploymentGroupArgsBuilder.() -> Unit) {
        val builder = DeploymentGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DeploymentGroup {
        val builtJavaResource = com.pulumi.aws.codedeploy.DeploymentGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DeploymentGroup(builtJavaResource)
    }
}

/**
 * Provides a CodeDeploy Deployment Group for a CodeDeploy Application
 * > **NOTE on blue/green deployments:** When using `green_fleet_provisioning_option` with the `COPY_AUTO_SCALING_GROUP` action, CodeDeploy will create a new ASG with a different name. This ASG is _not_ managed by this provider and will conflict with existing configuration and state. You may want to use a different approach to managing deployments that involve multiple ASG, such as `DISCOVER_EXISTING` with separate blue and green ASG.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.codedeploy.Application;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupEc2TagSetArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupTriggerConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAlarmConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("codedeploy.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var aWSCodeDeployRole = new RolePolicyAttachment("aWSCodeDeployRole", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole")
 *             .role(exampleRole.name())
 *             .build());
 *         var exampleApplication = new Application("exampleApplication");
 *         var exampleTopic = new Topic("exampleTopic");
 *         var exampleDeploymentGroup = new DeploymentGroup("exampleDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(exampleApplication.name())
 *             .deploymentGroupName("example-group")
 *             .serviceRoleArn(exampleRole.arn())
 *             .ec2TagSets(DeploymentGroupEc2TagSetArgs.builder()
 *                 .ec2TagFilters(
 *                     DeploymentGroupEc2TagSetEc2TagFilterArgs.builder()
 *                         .key("filterkey1")
 *                         .type("KEY_AND_VALUE")
 *                         .value("filtervalue")
 *                         .build(),
 *                     DeploymentGroupEc2TagSetEc2TagFilterArgs.builder()
 *                         .key("filterkey2")
 *                         .type("KEY_AND_VALUE")
 *                         .value("filtervalue")
 *                         .build())
 *                 .build())
 *             .triggerConfigurations(DeploymentGroupTriggerConfigurationArgs.builder()
 *                 .triggerEvents("DeploymentFailure")
 *                 .triggerName("example-trigger")
 *                 .triggerTargetArn(exampleTopic.arn())
 *                 .build())
 *             .autoRollbackConfiguration(DeploymentGroupAutoRollbackConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .events("DEPLOYMENT_FAILURE")
 *                 .build())
 *             .alarmConfiguration(DeploymentGroupAlarmConfigurationArgs.builder()
 *                 .alarms("my-alarm-name")
 *                 .enabled(true)
 *                 .build())
 *             .outdatedInstancesStrategy("UPDATE")
 *             .build());
 *     }
 * }
 * ```
 * ### Blue Green Deployments with ECS
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codedeploy.Application;
 * import com.pulumi.aws.codedeploy.ApplicationArgs;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupDeploymentStyleArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupEcsServiceArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .computePlatform("ECS")
 *             .build());
 *         var exampleDeploymentGroup = new DeploymentGroup("exampleDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(exampleApplication.name())
 *             .deploymentConfigName("CodeDeployDefault.ECSAllAtOnce")
 *             .deploymentGroupName("example")
 *             .serviceRoleArn(aws_iam_role.example().arn())
 *             .autoRollbackConfiguration(DeploymentGroupAutoRollbackConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .events("DEPLOYMENT_FAILURE")
 *                 .build())
 *             .blueGreenDeploymentConfig(DeploymentGroupBlueGreenDeploymentConfigArgs.builder()
 *                 .deploymentReadyOption(DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs.builder()
 *                     .actionOnTimeout("CONTINUE_DEPLOYMENT")
 *                     .build())
 *                 .terminateBlueInstancesOnDeploymentSuccess(DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs.builder()
 *                     .action("TERMINATE")
 *                     .terminationWaitTimeInMinutes(5)
 *                     .build())
 *                 .build())
 *             .deploymentStyle(DeploymentGroupDeploymentStyleArgs.builder()
 *                 .deploymentOption("WITH_TRAFFIC_CONTROL")
 *                 .deploymentType("BLUE_GREEN")
 *                 .build())
 *             .ecsService(DeploymentGroupEcsServiceArgs.builder()
 *                 .clusterName(aws_ecs_cluster.example().name())
 *                 .serviceName(aws_ecs_service.example().name())
 *                 .build())
 *             .loadBalancerInfo(DeploymentGroupLoadBalancerInfoArgs.builder()
 *                 .targetGroupPairInfo(DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs.builder()
 *                     .prodTrafficRoute(DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs.builder()
 *                         .listenerArns(aws_lb_listener.example().arn())
 *                         .build())
 *                     .targetGroups(
 *                         DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs.builder()
 *                             .name(aws_lb_target_group.blue().name())
 *                             .build(),
 *                         DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs.builder()
 *                             .name(aws_lb_target_group.green().name())
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Blue Green Deployments with Servers and Classic ELB
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codedeploy.Application;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupDeploymentStyleArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleApplication = new Application("exampleApplication");
 *         var exampleDeploymentGroup = new DeploymentGroup("exampleDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(exampleApplication.name())
 *             .deploymentGroupName("example-group")
 *             .serviceRoleArn(aws_iam_role.example().arn())
 *             .deploymentStyle(DeploymentGroupDeploymentStyleArgs.builder()
 *                 .deploymentOption("WITH_TRAFFIC_CONTROL")
 *                 .deploymentType("BLUE_GREEN")
 *                 .build())
 *             .loadBalancerInfo(DeploymentGroupLoadBalancerInfoArgs.builder()
 *                 .elbInfos(DeploymentGroupLoadBalancerInfoElbInfoArgs.builder()
 *                     .name(aws_elb.example().name())
 *                     .build())
 *                 .build())
 *             .blueGreenDeploymentConfig(DeploymentGroupBlueGreenDeploymentConfigArgs.builder()
 *                 .deploymentReadyOption(DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs.builder()
 *                     .actionOnTimeout("STOP_DEPLOYMENT")
 *                     .waitTimeInMinutes(60)
 *                     .build())
 *                 .greenFleetProvisioningOption(DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs.builder()
 *                     .action("DISCOVER_EXISTING")
 *                     .build())
 *                 .terminateBlueInstancesOnDeploymentSuccess(DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs.builder()
 *                     .action("KEEP_ALIVE")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeDeploy Deployment Groups using `app_name`, a colon, and `deployment_group_name`. For example:
 * ```sh
 *  $ pulumi import aws:codedeploy/deploymentGroup:DeploymentGroup example my-application:my-deployment-group
 * ```
 *
 */
public class DeploymentGroup internal constructor(
    override val javaResource: com.pulumi.aws.codedeploy.DeploymentGroup,
) : KotlinCustomResource(javaResource, DeploymentGroupMapper) {
    /**
     * Configuration block of alarms associated with the deployment group (documented below).
     */
    public val alarmConfiguration: Output<DeploymentGroupAlarmConfiguration>?
        get() = javaResource.alarmConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deploymentGroupAlarmConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the application.
     */
    public val appName: Output<String>
        get() = javaResource.appName().applyValue({ args0 -> args0 })

    /**
     * The ARN of the CodeDeploy deployment group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block of the automatic rollback configuration associated with the deployment group (documented below).
     */
    public val autoRollbackConfiguration: Output<DeploymentGroupAutoRollbackConfiguration>?
        get() = javaResource.autoRollbackConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    deploymentGroupAutoRollbackConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Autoscaling groups associated with the deployment group.
     */
    public val autoscalingGroups: Output<List<String>>?
        get() = javaResource.autoscalingGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Configuration block of the blue/green deployment options for a deployment group (documented below).
     */
    public val blueGreenDeploymentConfig: Output<DeploymentGroupBlueGreenDeploymentConfig>
        get() = javaResource.blueGreenDeploymentConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                deploymentGroupBlueGreenDeploymentConfigToKotlin(args0)
            })
        })

    /**
     * The destination platform type for the deployment.
     */
    public val computePlatform: Output<String>
        get() = javaResource.computePlatform().applyValue({ args0 -> args0 })

    /**
     * The name of the group's deployment config. The default is "CodeDeployDefault.OneAtATime".
     */
    public val deploymentConfigName: Output<String>?
        get() = javaResource.deploymentConfigName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the CodeDeploy deployment group.
     */
    public val deploymentGroupId: Output<String>
        get() = javaResource.deploymentGroupId().applyValue({ args0 -> args0 })

    /**
     * The name of the deployment group.
     */
    public val deploymentGroupName: Output<String>
        get() = javaResource.deploymentGroupName().applyValue({ args0 -> args0 })

    /**
     * Configuration block of the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer (documented below).
     */
    public val deploymentStyle: Output<DeploymentGroupDeploymentStyle>?
        get() = javaResource.deploymentStyle().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deploymentGroupDeploymentStyleToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Tag filters associated with the deployment group. See the AWS docs for details.
     */
    public val ec2TagFilters: Output<List<DeploymentGroupEc2TagFilter>>?
        get() = javaResource.ec2TagFilters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        deploymentGroupEc2TagFilterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
     */
    public val ec2TagSets: Output<List<DeploymentGroupEc2TagSet>>?
        get() = javaResource.ec2TagSets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> deploymentGroupEc2TagSetToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Configuration block(s) of the ECS services for a deployment group (documented below).
     */
    public val ecsService: Output<DeploymentGroupEcsService>?
        get() = javaResource.ecsService().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    deploymentGroupEcsServiceToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Single configuration block of the load balancer to use in a blue/green deployment (documented below).
     */
    public val loadBalancerInfo: Output<DeploymentGroupLoadBalancerInfo>?
        get() = javaResource.loadBalancerInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deploymentGroupLoadBalancerInfoToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * On premise tag filters associated with the group. See the AWS docs for details.
     */
    public val onPremisesInstanceTagFilters: Output<List<DeploymentGroupOnPremisesInstanceTagFilter>>?
        get() = javaResource.onPremisesInstanceTagFilters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        deploymentGroupOnPremisesInstanceTagFilterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block of Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision. Valid values are `UPDATE` and `IGNORE`. Defaults to `UPDATE`.
     */
    public val outdatedInstancesStrategy: Output<String>?
        get() = javaResource.outdatedInstancesStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The service role ARN that allows deployments.
     */
    public val serviceRoleArn: Output<String>
        get() = javaResource.serviceRoleArn().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block(s) of the triggers for the deployment group (documented below).
     */
    public val triggerConfigurations: Output<List<DeploymentGroupTriggerConfiguration>>?
        get() = javaResource.triggerConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        deploymentGroupTriggerConfigurationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object DeploymentGroupMapper : ResourceMapper<DeploymentGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codedeploy.DeploymentGroup::class == javaResource::class

    override fun map(javaResource: Resource): DeploymentGroup = DeploymentGroup(
        javaResource as
            com.pulumi.aws.codedeploy.DeploymentGroup,
    )
}

/**
 * @see [DeploymentGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DeploymentGroup].
 */
public suspend fun deploymentGroup(
    name: String,
    block: suspend DeploymentGroupResourceBuilder.() -> Unit,
): DeploymentGroup {
    val builder = DeploymentGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DeploymentGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deploymentGroup(name: String): DeploymentGroup {
    val builder = DeploymentGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
