@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin

import com.pulumi.aws.codedeploy.DeploymentGroupArgs.builder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupAlarmConfigurationArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupAlarmConfigurationArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupAutoRollbackConfigurationArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupAutoRollbackConfigurationArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupBlueGreenDeploymentConfigArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupBlueGreenDeploymentConfigArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupDeploymentStyleArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupDeploymentStyleArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupEc2TagFilterArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupEc2TagFilterArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupEc2TagSetArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupEc2TagSetArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupEcsServiceArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupEcsServiceArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupLoadBalancerInfoArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupLoadBalancerInfoArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupOnPremisesInstanceTagFilterArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupOnPremisesInstanceTagFilterArgsBuilder
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupTriggerConfigurationArgs
import com.pulumi.aws.codedeploy.kotlin.inputs.DeploymentGroupTriggerConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodeDeploy Deployment Group for a CodeDeploy Application
 * > **NOTE on blue/green deployments:** When using `green_fleet_provisioning_option` with the `COPY_AUTO_SCALING_GROUP` action, CodeDeploy will create a new ASG with a different name. This ASG is _not_ managed by this provider and will conflict with existing configuration and state. You may want to use a different approach to managing deployments that involve multiple ASG, such as `DISCOVER_EXISTING` with separate blue and green ASG.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.codedeploy.Application;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupEc2TagSetArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupTriggerConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAlarmConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("codedeploy.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var aWSCodeDeployRole = new RolePolicyAttachment("aWSCodeDeployRole", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole")
 *             .role(exampleRole.name())
 *             .build());
 *         var exampleApplication = new Application("exampleApplication");
 *         var exampleTopic = new Topic("exampleTopic");
 *         var exampleDeploymentGroup = new DeploymentGroup("exampleDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(exampleApplication.name())
 *             .deploymentGroupName("example-group")
 *             .serviceRoleArn(exampleRole.arn())
 *             .ec2TagSets(DeploymentGroupEc2TagSetArgs.builder()
 *                 .ec2TagFilters(
 *                     DeploymentGroupEc2TagSetEc2TagFilterArgs.builder()
 *                         .key("filterkey1")
 *                         .type("KEY_AND_VALUE")
 *                         .value("filtervalue")
 *                         .build(),
 *                     DeploymentGroupEc2TagSetEc2TagFilterArgs.builder()
 *                         .key("filterkey2")
 *                         .type("KEY_AND_VALUE")
 *                         .value("filtervalue")
 *                         .build())
 *                 .build())
 *             .triggerConfigurations(DeploymentGroupTriggerConfigurationArgs.builder()
 *                 .triggerEvents("DeploymentFailure")
 *                 .triggerName("example-trigger")
 *                 .triggerTargetArn(exampleTopic.arn())
 *                 .build())
 *             .autoRollbackConfiguration(DeploymentGroupAutoRollbackConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .events("DEPLOYMENT_FAILURE")
 *                 .build())
 *             .alarmConfiguration(DeploymentGroupAlarmConfigurationArgs.builder()
 *                 .alarms("my-alarm-name")
 *                 .enabled(true)
 *                 .build())
 *             .outdatedInstancesStrategy("UPDATE")
 *             .build());
 *     }
 * }
 * ```
 * ### Blue Green Deployments with ECS
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codedeploy.Application;
 * import com.pulumi.aws.codedeploy.ApplicationArgs;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupDeploymentStyleArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupEcsServiceArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .computePlatform("ECS")
 *             .build());
 *         var exampleDeploymentGroup = new DeploymentGroup("exampleDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(exampleApplication.name())
 *             .deploymentConfigName("CodeDeployDefault.ECSAllAtOnce")
 *             .deploymentGroupName("example")
 *             .serviceRoleArn(aws_iam_role.example().arn())
 *             .autoRollbackConfiguration(DeploymentGroupAutoRollbackConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .events("DEPLOYMENT_FAILURE")
 *                 .build())
 *             .blueGreenDeploymentConfig(DeploymentGroupBlueGreenDeploymentConfigArgs.builder()
 *                 .deploymentReadyOption(DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs.builder()
 *                     .actionOnTimeout("CONTINUE_DEPLOYMENT")
 *                     .build())
 *                 .terminateBlueInstancesOnDeploymentSuccess(DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs.builder()
 *                     .action("TERMINATE")
 *                     .terminationWaitTimeInMinutes(5)
 *                     .build())
 *                 .build())
 *             .deploymentStyle(DeploymentGroupDeploymentStyleArgs.builder()
 *                 .deploymentOption("WITH_TRAFFIC_CONTROL")
 *                 .deploymentType("BLUE_GREEN")
 *                 .build())
 *             .ecsService(DeploymentGroupEcsServiceArgs.builder()
 *                 .clusterName(aws_ecs_cluster.example().name())
 *                 .serviceName(aws_ecs_service.example().name())
 *                 .build())
 *             .loadBalancerInfo(DeploymentGroupLoadBalancerInfoArgs.builder()
 *                 .targetGroupPairInfo(DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs.builder()
 *                     .prodTrafficRoute(DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs.builder()
 *                         .listenerArns(aws_lb_listener.example().arn())
 *                         .build())
 *                     .targetGroups(
 *                         DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs.builder()
 *                             .name(aws_lb_target_group.blue().name())
 *                             .build(),
 *                         DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs.builder()
 *                             .name(aws_lb_target_group.green().name())
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Blue Green Deployments with Servers and Classic ELB
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codedeploy.Application;
 * import com.pulumi.aws.codedeploy.DeploymentGroup;
 * import com.pulumi.aws.codedeploy.DeploymentGroupArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupDeploymentStyleArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupLoadBalancerInfoArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs;
 * import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleApplication = new Application("exampleApplication");
 *         var exampleDeploymentGroup = new DeploymentGroup("exampleDeploymentGroup", DeploymentGroupArgs.builder()
 *             .appName(exampleApplication.name())
 *             .deploymentGroupName("example-group")
 *             .serviceRoleArn(aws_iam_role.example().arn())
 *             .deploymentStyle(DeploymentGroupDeploymentStyleArgs.builder()
 *                 .deploymentOption("WITH_TRAFFIC_CONTROL")
 *                 .deploymentType("BLUE_GREEN")
 *                 .build())
 *             .loadBalancerInfo(DeploymentGroupLoadBalancerInfoArgs.builder()
 *                 .elbInfos(DeploymentGroupLoadBalancerInfoElbInfoArgs.builder()
 *                     .name(aws_elb.example().name())
 *                     .build())
 *                 .build())
 *             .blueGreenDeploymentConfig(DeploymentGroupBlueGreenDeploymentConfigArgs.builder()
 *                 .deploymentReadyOption(DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs.builder()
 *                     .actionOnTimeout("STOP_DEPLOYMENT")
 *                     .waitTimeInMinutes(60)
 *                     .build())
 *                 .greenFleetProvisioningOption(DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs.builder()
 *                     .action("DISCOVER_EXISTING")
 *                     .build())
 *                 .terminateBlueInstancesOnDeploymentSuccess(DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs.builder()
 *                     .action("KEEP_ALIVE")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeDeploy Deployment Groups using `app_name`, a colon, and `deployment_group_name`. For example:
 * ```sh
 *  $ pulumi import aws:codedeploy/deploymentGroup:DeploymentGroup example my-application:my-deployment-group
 * ```
 * @property alarmConfiguration Configuration block of alarms associated with the deployment group (documented below).
 * @property appName The name of the application.
 * @property autoRollbackConfiguration Configuration block of the automatic rollback configuration associated with the deployment group (documented below).
 * @property autoscalingGroups Autoscaling groups associated with the deployment group.
 * @property blueGreenDeploymentConfig Configuration block of the blue/green deployment options for a deployment group (documented below).
 * @property deploymentConfigName The name of the group's deployment config. The default is "CodeDeployDefault.OneAtATime".
 * @property deploymentGroupName The name of the deployment group.
 * @property deploymentStyle Configuration block of the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer (documented below).
 * @property ec2TagFilters Tag filters associated with the deployment group. See the AWS docs for details.
 * @property ec2TagSets Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
 * @property ecsService Configuration block(s) of the ECS services for a deployment group (documented below).
 * @property loadBalancerInfo Single configuration block of the load balancer to use in a blue/green deployment (documented below).
 * @property onPremisesInstanceTagFilters On premise tag filters associated with the group. See the AWS docs for details.
 * @property outdatedInstancesStrategy Configuration block of Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision. Valid values are `UPDATE` and `IGNORE`. Defaults to `UPDATE`.
 * @property serviceRoleArn The service role ARN that allows deployments.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property triggerConfigurations Configuration block(s) of the triggers for the deployment group (documented below).
 */
public data class DeploymentGroupArgs(
    public val alarmConfiguration: Output<DeploymentGroupAlarmConfigurationArgs>? = null,
    public val appName: Output<String>? = null,
    public val autoRollbackConfiguration: Output<DeploymentGroupAutoRollbackConfigurationArgs>? =
        null,
    public val autoscalingGroups: Output<List<String>>? = null,
    public val blueGreenDeploymentConfig: Output<DeploymentGroupBlueGreenDeploymentConfigArgs>? =
        null,
    public val deploymentConfigName: Output<String>? = null,
    public val deploymentGroupName: Output<String>? = null,
    public val deploymentStyle: Output<DeploymentGroupDeploymentStyleArgs>? = null,
    public val ec2TagFilters: Output<List<DeploymentGroupEc2TagFilterArgs>>? = null,
    public val ec2TagSets: Output<List<DeploymentGroupEc2TagSetArgs>>? = null,
    public val ecsService: Output<DeploymentGroupEcsServiceArgs>? = null,
    public val loadBalancerInfo: Output<DeploymentGroupLoadBalancerInfoArgs>? = null,
    public val onPremisesInstanceTagFilters:
    Output<List<DeploymentGroupOnPremisesInstanceTagFilterArgs>>? = null,
    public val outdatedInstancesStrategy: Output<String>? = null,
    public val serviceRoleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val triggerConfigurations: Output<List<DeploymentGroupTriggerConfigurationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codedeploy.DeploymentGroupArgs> {
    override fun toJava(): com.pulumi.aws.codedeploy.DeploymentGroupArgs =
        com.pulumi.aws.codedeploy.DeploymentGroupArgs.builder()
            .alarmConfiguration(
                alarmConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .appName(appName?.applyValue({ args0 -> args0 }))
            .autoRollbackConfiguration(
                autoRollbackConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .autoscalingGroups(autoscalingGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .blueGreenDeploymentConfig(
                blueGreenDeploymentConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .deploymentConfigName(deploymentConfigName?.applyValue({ args0 -> args0 }))
            .deploymentGroupName(deploymentGroupName?.applyValue({ args0 -> args0 }))
            .deploymentStyle(deploymentStyle?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ec2TagFilters(
                ec2TagFilters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ec2TagSets(
                ec2TagSets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ecsService(ecsService?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .loadBalancerInfo(loadBalancerInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .onPremisesInstanceTagFilters(
                onPremisesInstanceTagFilters?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .outdatedInstancesStrategy(outdatedInstancesStrategy?.applyValue({ args0 -> args0 }))
            .serviceRoleArn(serviceRoleArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .triggerConfigurations(
                triggerConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DeploymentGroupArgs].
 */
@PulumiTagMarker
public class DeploymentGroupArgsBuilder internal constructor() {
    private var alarmConfiguration: Output<DeploymentGroupAlarmConfigurationArgs>? = null

    private var appName: Output<String>? = null

    private var autoRollbackConfiguration: Output<DeploymentGroupAutoRollbackConfigurationArgs>? =
        null

    private var autoscalingGroups: Output<List<String>>? = null

    private var blueGreenDeploymentConfig: Output<DeploymentGroupBlueGreenDeploymentConfigArgs>? =
        null

    private var deploymentConfigName: Output<String>? = null

    private var deploymentGroupName: Output<String>? = null

    private var deploymentStyle: Output<DeploymentGroupDeploymentStyleArgs>? = null

    private var ec2TagFilters: Output<List<DeploymentGroupEc2TagFilterArgs>>? = null

    private var ec2TagSets: Output<List<DeploymentGroupEc2TagSetArgs>>? = null

    private var ecsService: Output<DeploymentGroupEcsServiceArgs>? = null

    private var loadBalancerInfo: Output<DeploymentGroupLoadBalancerInfoArgs>? = null

    private var onPremisesInstanceTagFilters:
        Output<List<DeploymentGroupOnPremisesInstanceTagFilterArgs>>? = null

    private var outdatedInstancesStrategy: Output<String>? = null

    private var serviceRoleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var triggerConfigurations: Output<List<DeploymentGroupTriggerConfigurationArgs>>? = null

    /**
     * @param value Configuration block of alarms associated with the deployment group (documented below).
     */
    @JvmName("wjjydwlycafpdokc")
    public suspend fun alarmConfiguration(`value`: Output<DeploymentGroupAlarmConfigurationArgs>) {
        this.alarmConfiguration = value
    }

    /**
     * @param value The name of the application.
     */
    @JvmName("abihmtcimgmjdrjo")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value Configuration block of the automatic rollback configuration associated with the deployment group (documented below).
     */
    @JvmName("alnaxjgugfxvobvc")
    public suspend
    fun autoRollbackConfiguration(`value`: Output<DeploymentGroupAutoRollbackConfigurationArgs>) {
        this.autoRollbackConfiguration = value
    }

    /**
     * @param value Autoscaling groups associated with the deployment group.
     */
    @JvmName("mojmjkdhktumlqii")
    public suspend fun autoscalingGroups(`value`: Output<List<String>>) {
        this.autoscalingGroups = value
    }

    @JvmName("auttjkhbdscrjgss")
    public suspend fun autoscalingGroups(vararg values: Output<String>) {
        this.autoscalingGroups = Output.all(values.asList())
    }

    /**
     * @param values Autoscaling groups associated with the deployment group.
     */
    @JvmName("sryvmukmxtjnybmc")
    public suspend fun autoscalingGroups(values: List<Output<String>>) {
        this.autoscalingGroups = Output.all(values)
    }

    /**
     * @param value Configuration block of the blue/green deployment options for a deployment group (documented below).
     */
    @JvmName("rvjjyborologobwu")
    public suspend
    fun blueGreenDeploymentConfig(`value`: Output<DeploymentGroupBlueGreenDeploymentConfigArgs>) {
        this.blueGreenDeploymentConfig = value
    }

    /**
     * @param value The name of the group's deployment config. The default is "CodeDeployDefault.OneAtATime".
     */
    @JvmName("rvpomriqiomtujeh")
    public suspend fun deploymentConfigName(`value`: Output<String>) {
        this.deploymentConfigName = value
    }

    /**
     * @param value The name of the deployment group.
     */
    @JvmName("jdetefoxihojkwnr")
    public suspend fun deploymentGroupName(`value`: Output<String>) {
        this.deploymentGroupName = value
    }

    /**
     * @param value Configuration block of the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer (documented below).
     */
    @JvmName("ffeatpnjrhqvognr")
    public suspend fun deploymentStyle(`value`: Output<DeploymentGroupDeploymentStyleArgs>) {
        this.deploymentStyle = value
    }

    /**
     * @param value Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("aslqkuqimwfhpjba")
    public suspend fun ec2TagFilters(`value`: Output<List<DeploymentGroupEc2TagFilterArgs>>) {
        this.ec2TagFilters = value
    }

    @JvmName("xlsoatmxabtyfnax")
    public suspend fun ec2TagFilters(vararg values: Output<DeploymentGroupEc2TagFilterArgs>) {
        this.ec2TagFilters = Output.all(values.asList())
    }

    /**
     * @param values Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("qsfahgejpugpiree")
    public suspend fun ec2TagFilters(values: List<Output<DeploymentGroupEc2TagFilterArgs>>) {
        this.ec2TagFilters = Output.all(values)
    }

    /**
     * @param value Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
     */
    @JvmName("piohxdfavqbfhiqb")
    public suspend fun ec2TagSets(`value`: Output<List<DeploymentGroupEc2TagSetArgs>>) {
        this.ec2TagSets = value
    }

    @JvmName("mvbjqernljdbbeae")
    public suspend fun ec2TagSets(vararg values: Output<DeploymentGroupEc2TagSetArgs>) {
        this.ec2TagSets = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
     */
    @JvmName("ufydbawqslsfbtkt")
    public suspend fun ec2TagSets(values: List<Output<DeploymentGroupEc2TagSetArgs>>) {
        this.ec2TagSets = Output.all(values)
    }

    /**
     * @param value Configuration block(s) of the ECS services for a deployment group (documented below).
     */
    @JvmName("nhwgqbhymrilsyyg")
    public suspend fun ecsService(`value`: Output<DeploymentGroupEcsServiceArgs>) {
        this.ecsService = value
    }

    /**
     * @param value Single configuration block of the load balancer to use in a blue/green deployment (documented below).
     */
    @JvmName("jtwxdjspirvlqypa")
    public suspend fun loadBalancerInfo(`value`: Output<DeploymentGroupLoadBalancerInfoArgs>) {
        this.loadBalancerInfo = value
    }

    /**
     * @param value On premise tag filters associated with the group. See the AWS docs for details.
     */
    @JvmName("gbaweyttbkjesqve")
    public suspend
    fun onPremisesInstanceTagFilters(`value`: Output<List<DeploymentGroupOnPremisesInstanceTagFilterArgs>>) {
        this.onPremisesInstanceTagFilters = value
    }

    @JvmName("gsavwkovphuomjyl")
    public suspend fun onPremisesInstanceTagFilters(
        vararg
        values: Output<DeploymentGroupOnPremisesInstanceTagFilterArgs>,
    ) {
        this.onPremisesInstanceTagFilters = Output.all(values.asList())
    }

    /**
     * @param values On premise tag filters associated with the group. See the AWS docs for details.
     */
    @JvmName("bytltqhbxxqdfdil")
    public suspend
    fun onPremisesInstanceTagFilters(values: List<Output<DeploymentGroupOnPremisesInstanceTagFilterArgs>>) {
        this.onPremisesInstanceTagFilters = Output.all(values)
    }

    /**
     * @param value Configuration block of Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision. Valid values are `UPDATE` and `IGNORE`. Defaults to `UPDATE`.
     */
    @JvmName("ekfxcbybjwxowtyi")
    public suspend fun outdatedInstancesStrategy(`value`: Output<String>) {
        this.outdatedInstancesStrategy = value
    }

    /**
     * @param value The service role ARN that allows deployments.
     */
    @JvmName("ssskwixvglpjhndr")
    public suspend fun serviceRoleArn(`value`: Output<String>) {
        this.serviceRoleArn = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vbmxvnahwogiamlp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block(s) of the triggers for the deployment group (documented below).
     */
    @JvmName("omgbxqbsieniyxoo")
    public suspend
    fun triggerConfigurations(`value`: Output<List<DeploymentGroupTriggerConfigurationArgs>>) {
        this.triggerConfigurations = value
    }

    @JvmName("jhtncsdwxsmwerda")
    public suspend fun triggerConfigurations(
        vararg
        values: Output<DeploymentGroupTriggerConfigurationArgs>,
    ) {
        this.triggerConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) of the triggers for the deployment group (documented below).
     */
    @JvmName("gymqatujrviijrft")
    public suspend
    fun triggerConfigurations(values: List<Output<DeploymentGroupTriggerConfigurationArgs>>) {
        this.triggerConfigurations = Output.all(values)
    }

    /**
     * @param value Configuration block of alarms associated with the deployment group (documented below).
     */
    @JvmName("ofeljqywafberska")
    public suspend fun alarmConfiguration(`value`: DeploymentGroupAlarmConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarmConfiguration = mapped
    }

    /**
     * @param argument Configuration block of alarms associated with the deployment group (documented below).
     */
    @JvmName("ovollqevwsnkgser")
    public suspend
    fun alarmConfiguration(argument: suspend DeploymentGroupAlarmConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentGroupAlarmConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.alarmConfiguration = mapped
    }

    /**
     * @param value The name of the application.
     */
    @JvmName("iqipgtsnuqqinjok")
    public suspend fun appName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value Configuration block of the automatic rollback configuration associated with the deployment group (documented below).
     */
    @JvmName("xuwowclrjvsvqdlf")
    public suspend
    fun autoRollbackConfiguration(`value`: DeploymentGroupAutoRollbackConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRollbackConfiguration = mapped
    }

    /**
     * @param argument Configuration block of the automatic rollback configuration associated with the deployment group (documented below).
     */
    @JvmName("eqkinaibgpsekjpi")
    public suspend
    fun autoRollbackConfiguration(argument: suspend DeploymentGroupAutoRollbackConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentGroupAutoRollbackConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoRollbackConfiguration = mapped
    }

    /**
     * @param value Autoscaling groups associated with the deployment group.
     */
    @JvmName("ptmvlbrqnqvnpand")
    public suspend fun autoscalingGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscalingGroups = mapped
    }

    /**
     * @param values Autoscaling groups associated with the deployment group.
     */
    @JvmName("eajyklvpnqfnpeqg")
    public suspend fun autoscalingGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoscalingGroups = mapped
    }

    /**
     * @param value Configuration block of the blue/green deployment options for a deployment group (documented below).
     */
    @JvmName("fiiynhivnfebikhj")
    public suspend
    fun blueGreenDeploymentConfig(`value`: DeploymentGroupBlueGreenDeploymentConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blueGreenDeploymentConfig = mapped
    }

    /**
     * @param argument Configuration block of the blue/green deployment options for a deployment group (documented below).
     */
    @JvmName("nwxxdfufkqnfjdbw")
    public suspend
    fun blueGreenDeploymentConfig(argument: suspend DeploymentGroupBlueGreenDeploymentConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentGroupBlueGreenDeploymentConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.blueGreenDeploymentConfig = mapped
    }

    /**
     * @param value The name of the group's deployment config. The default is "CodeDeployDefault.OneAtATime".
     */
    @JvmName("udsjfnyjmriopwxe")
    public suspend fun deploymentConfigName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentConfigName = mapped
    }

    /**
     * @param value The name of the deployment group.
     */
    @JvmName("wxtmxfcjxwmohuin")
    public suspend fun deploymentGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentGroupName = mapped
    }

    /**
     * @param value Configuration block of the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer (documented below).
     */
    @JvmName("dkrsymrmjxfniidc")
    public suspend fun deploymentStyle(`value`: DeploymentGroupDeploymentStyleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentStyle = mapped
    }

    /**
     * @param argument Configuration block of the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer (documented below).
     */
    @JvmName("nrsmcvymbpquknjh")
    public suspend
    fun deploymentStyle(argument: suspend DeploymentGroupDeploymentStyleArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentGroupDeploymentStyleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deploymentStyle = mapped
    }

    /**
     * @param value Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("vdbvvwtfusvmxcjc")
    public suspend fun ec2TagFilters(`value`: List<DeploymentGroupEc2TagFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ec2TagFilters = mapped
    }

    /**
     * @param argument Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("unjaairsbsgkqhrp")
    public suspend
    fun ec2TagFilters(argument: List<suspend DeploymentGroupEc2TagFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupEc2TagFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ec2TagFilters = mapped
    }

    /**
     * @param argument Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("tlvpxygjfcrhnruv")
    public suspend fun ec2TagFilters(
        vararg
        argument: suspend DeploymentGroupEc2TagFilterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupEc2TagFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ec2TagFilters = mapped
    }

    /**
     * @param argument Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("bvmyjnhaloofjblo")
    public suspend
    fun ec2TagFilters(argument: suspend DeploymentGroupEc2TagFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DeploymentGroupEc2TagFilterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ec2TagFilters = mapped
    }

    /**
     * @param values Tag filters associated with the deployment group. See the AWS docs for details.
     */
    @JvmName("bpwyhayckuadmefr")
    public suspend fun ec2TagFilters(vararg values: DeploymentGroupEc2TagFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ec2TagFilters = mapped
    }

    /**
     * @param value Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
     */
    @JvmName("sgylqioocwlbgmcl")
    public suspend fun ec2TagSets(`value`: List<DeploymentGroupEc2TagSetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ec2TagSets = mapped
    }

    /**
     * @param argument Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
     */
    @JvmName("dbfycfxtfmmpfldr")
    public suspend
    fun ec2TagSets(argument: List<suspend DeploymentGroupEc2TagSetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupEc2TagSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ec2TagSets = mapped
    }

    /**
     * @param argument Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
     */
    @JvmName("xfkukcidltgojaso")
    public suspend fun ec2TagSets(
        vararg
        argument: suspend DeploymentGroupEc2TagSetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupEc2TagSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ec2TagSets = mapped
    }

    /**
     * @param argument Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
     */
    @JvmName("eqhspfwcgbynsyko")
    public suspend fun ec2TagSets(argument: suspend DeploymentGroupEc2TagSetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DeploymentGroupEc2TagSetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ec2TagSets = mapped
    }

    /**
     * @param values Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
     */
    @JvmName("qndtokymbwmtqcjw")
    public suspend fun ec2TagSets(vararg values: DeploymentGroupEc2TagSetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ec2TagSets = mapped
    }

    /**
     * @param value Configuration block(s) of the ECS services for a deployment group (documented below).
     */
    @JvmName("vhjugurlbbqgiovp")
    public suspend fun ecsService(`value`: DeploymentGroupEcsServiceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsService = mapped
    }

    /**
     * @param argument Configuration block(s) of the ECS services for a deployment group (documented below).
     */
    @JvmName("uglsmxintmpdkdur")
    public suspend fun ecsService(argument: suspend DeploymentGroupEcsServiceArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentGroupEcsServiceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ecsService = mapped
    }

    /**
     * @param value Single configuration block of the load balancer to use in a blue/green deployment (documented below).
     */
    @JvmName("hfdlxvkghjxobprn")
    public suspend fun loadBalancerInfo(`value`: DeploymentGroupLoadBalancerInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerInfo = mapped
    }

    /**
     * @param argument Single configuration block of the load balancer to use in a blue/green deployment (documented below).
     */
    @JvmName("rrtmqxmsplcblafi")
    public suspend
    fun loadBalancerInfo(argument: suspend DeploymentGroupLoadBalancerInfoArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentGroupLoadBalancerInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loadBalancerInfo = mapped
    }

    /**
     * @param value On premise tag filters associated with the group. See the AWS docs for details.
     */
    @JvmName("faoblhkevpsieyxt")
    public suspend
    fun onPremisesInstanceTagFilters(`value`: List<DeploymentGroupOnPremisesInstanceTagFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onPremisesInstanceTagFilters = mapped
    }

    /**
     * @param argument On premise tag filters associated with the group. See the AWS docs for details.
     */
    @JvmName("owegphwfhcfukfre")
    public suspend
    fun onPremisesInstanceTagFilters(argument: List<suspend DeploymentGroupOnPremisesInstanceTagFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupOnPremisesInstanceTagFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.onPremisesInstanceTagFilters = mapped
    }

    /**
     * @param argument On premise tag filters associated with the group. See the AWS docs for details.
     */
    @JvmName("owfbmnvlhjgtsudf")
    public suspend fun onPremisesInstanceTagFilters(
        vararg
        argument: suspend DeploymentGroupOnPremisesInstanceTagFilterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupOnPremisesInstanceTagFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.onPremisesInstanceTagFilters = mapped
    }

    /**
     * @param argument On premise tag filters associated with the group. See the AWS docs for details.
     */
    @JvmName("utqprgrfxialhuyl")
    public suspend
    fun onPremisesInstanceTagFilters(argument: suspend DeploymentGroupOnPremisesInstanceTagFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DeploymentGroupOnPremisesInstanceTagFilterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.onPremisesInstanceTagFilters = mapped
    }

    /**
     * @param values On premise tag filters associated with the group. See the AWS docs for details.
     */
    @JvmName("xofberftmeiximev")
    public suspend fun onPremisesInstanceTagFilters(
        vararg
        values: DeploymentGroupOnPremisesInstanceTagFilterArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onPremisesInstanceTagFilters = mapped
    }

    /**
     * @param value Configuration block of Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision. Valid values are `UPDATE` and `IGNORE`. Defaults to `UPDATE`.
     */
    @JvmName("xfjwxtqcuqghbyol")
    public suspend fun outdatedInstancesStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outdatedInstancesStrategy = mapped
    }

    /**
     * @param value The service role ARN that allows deployments.
     */
    @JvmName("evxscctqqwxjvaxm")
    public suspend fun serviceRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRoleArn = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bikygilmuemnwkjy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("moshukecmayhuxhr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block(s) of the triggers for the deployment group (documented below).
     */
    @JvmName("ojfypltdhkeovfxc")
    public suspend
    fun triggerConfigurations(`value`: List<DeploymentGroupTriggerConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerConfigurations = mapped
    }

    /**
     * @param argument Configuration block(s) of the triggers for the deployment group (documented below).
     */
    @JvmName("xxcsslbonyctmpyt")
    public suspend
    fun triggerConfigurations(argument: List<suspend DeploymentGroupTriggerConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupTriggerConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.triggerConfigurations = mapped
    }

    /**
     * @param argument Configuration block(s) of the triggers for the deployment group (documented below).
     */
    @JvmName("bpadwwyxfadiecfo")
    public suspend fun triggerConfigurations(
        vararg
        argument: suspend DeploymentGroupTriggerConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DeploymentGroupTriggerConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.triggerConfigurations = mapped
    }

    /**
     * @param argument Configuration block(s) of the triggers for the deployment group (documented below).
     */
    @JvmName("nihmawmjyxknuebg")
    public suspend
    fun triggerConfigurations(argument: suspend DeploymentGroupTriggerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DeploymentGroupTriggerConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.triggerConfigurations = mapped
    }

    /**
     * @param values Configuration block(s) of the triggers for the deployment group (documented below).
     */
    @JvmName("rcqikrusaiinaspj")
    public suspend fun triggerConfigurations(vararg values: DeploymentGroupTriggerConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerConfigurations = mapped
    }

    internal fun build(): DeploymentGroupArgs = DeploymentGroupArgs(
        alarmConfiguration = alarmConfiguration,
        appName = appName,
        autoRollbackConfiguration = autoRollbackConfiguration,
        autoscalingGroups = autoscalingGroups,
        blueGreenDeploymentConfig = blueGreenDeploymentConfig,
        deploymentConfigName = deploymentConfigName,
        deploymentGroupName = deploymentGroupName,
        deploymentStyle = deploymentStyle,
        ec2TagFilters = ec2TagFilters,
        ec2TagSets = ec2TagSets,
        ecsService = ecsService,
        loadBalancerInfo = loadBalancerInfo,
        onPremisesInstanceTagFilters = onPremisesInstanceTagFilters,
        outdatedInstancesStrategy = outdatedInstancesStrategy,
        serviceRoleArn = serviceRoleArn,
        tags = tags,
        triggerConfigurations = triggerConfigurations,
    )
}
