@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentConfigMinimumHealthyHostsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type The type can either be `FLEET_PERCENT` or `HOST_COUNT`.
 * @property value The value when the type is `FLEET_PERCENT` represents the minimum number of healthy instances as
 * a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the
 * deployment, AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional instances.
 * When the type is `HOST_COUNT`, the value represents the minimum number of healthy instances as an absolute value.
 */
public data class DeploymentConfigMinimumHealthyHostsArgs(
    public val type: Output<String>? = null,
    public val `value`: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentConfigMinimumHealthyHostsArgs> {
    override fun toJava(): com.pulumi.aws.codedeploy.inputs.DeploymentConfigMinimumHealthyHostsArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentConfigMinimumHealthyHostsArgs.builder()
            .type(type?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentConfigMinimumHealthyHostsArgs].
 */
@PulumiTagMarker
public class DeploymentConfigMinimumHealthyHostsArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var `value`: Output<Int>? = null

    /**
     * @param value The type can either be `FLEET_PERCENT` or `HOST_COUNT`.
     */
    @JvmName("vciyuynbvskjvlow")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The value when the type is `FLEET_PERCENT` represents the minimum number of healthy instances as
     * a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the
     * deployment, AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional instances.
     * When the type is `HOST_COUNT`, the value represents the minimum number of healthy instances as an absolute value.
     */
    @JvmName("sbfmkkpieuoqqafu")
    public suspend fun `value`(`value`: Output<Int>) {
        this.`value` = value
    }

    /**
     * @param value The type can either be `FLEET_PERCENT` or `HOST_COUNT`.
     */
    @JvmName("lpcvlyepkerjhfxh")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The value when the type is `FLEET_PERCENT` represents the minimum number of healthy instances as
     * a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the
     * deployment, AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional instances.
     * When the type is `HOST_COUNT`, the value represents the minimum number of healthy instances as an absolute value.
     */
    @JvmName("bgykxxfsfwtqlinf")
    public suspend fun `value`(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): DeploymentConfigMinimumHealthyHostsArgs =
        DeploymentConfigMinimumHealthyHostsArgs(
            type = type,
            `value` = `value`,
        )
}
