@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigTimeBasedCanaryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property interval The number of minutes between the first and second traffic shifts of a `TimeBasedCanary` deployment.
 * @property percentage The percentage of traffic to shift in the first increment of a `TimeBasedCanary` deployment.
 */
public data class DeploymentConfigTrafficRoutingConfigTimeBasedCanaryArgs(
    public val interval: Output<Int>? = null,
    public val percentage: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigTimeBasedCanaryArgs> {
    override fun toJava():
        com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigTimeBasedCanaryArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentConfigTrafficRoutingConfigTimeBasedCanaryArgs.builder()
            .interval(interval?.applyValue({ args0 -> args0 }))
            .percentage(percentage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentConfigTrafficRoutingConfigTimeBasedCanaryArgs].
 */
@PulumiTagMarker
public class DeploymentConfigTrafficRoutingConfigTimeBasedCanaryArgsBuilder internal constructor() {
    private var interval: Output<Int>? = null

    private var percentage: Output<Int>? = null

    /**
     * @param value The number of minutes between the first and second traffic shifts of a `TimeBasedCanary` deployment.
     */
    @JvmName("bmakftldlpuflyrc")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value The percentage of traffic to shift in the first increment of a `TimeBasedCanary` deployment.
     */
    @JvmName("inqbkhejoglrwjxi")
    public suspend fun percentage(`value`: Output<Int>) {
        this.percentage = value
    }

    /**
     * @param value The number of minutes between the first and second traffic shifts of a `TimeBasedCanary` deployment.
     */
    @JvmName("mcxqgppsqmugvrbv")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The percentage of traffic to shift in the first increment of a `TimeBasedCanary` deployment.
     */
    @JvmName("ywaijuklnfpflcln")
    public suspend fun percentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.percentage = mapped
    }

    internal fun build(): DeploymentConfigTrafficRoutingConfigTimeBasedCanaryArgs =
        DeploymentConfigTrafficRoutingConfigTimeBasedCanaryArgs(
            interval = interval,
            percentage = percentage,
        )
}
