@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Indicates whether a defined automatic rollback configuration is currently enabled for this Deployment Group. If you enable automatic rollback, you must specify at least one event type.
 * @property events The event type or types that trigger a rollback. Supported types are `DEPLOYMENT_FAILURE`, `DEPLOYMENT_STOP_ON_ALARM` and `DEPLOYMENT_STOP_ON_REQUEST`.
 * _Only one `auto_rollback_configuration` is allowed_.
 */
public data class DeploymentGroupAutoRollbackConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val events: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentGroupAutoRollbackConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .events(events?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DeploymentGroupAutoRollbackConfigurationArgs].
 */
@PulumiTagMarker
public class DeploymentGroupAutoRollbackConfigurationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var events: Output<List<String>>? = null

    /**
     * @param value Indicates whether a defined automatic rollback configuration is currently enabled for this Deployment Group. If you enable automatic rollback, you must specify at least one event type.
     */
    @JvmName("orxndbbyjfvbwudb")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The event type or types that trigger a rollback. Supported types are `DEPLOYMENT_FAILURE`, `DEPLOYMENT_STOP_ON_ALARM` and `DEPLOYMENT_STOP_ON_REQUEST`.
     * _Only one `auto_rollback_configuration` is allowed_.
     */
    @JvmName("mlbxutjvypatuhld")
    public suspend fun events(`value`: Output<List<String>>) {
        this.events = value
    }

    @JvmName("gqtapomjfsgtxoki")
    public suspend fun events(vararg values: Output<String>) {
        this.events = Output.all(values.asList())
    }

    /**
     * @param values The event type or types that trigger a rollback. Supported types are `DEPLOYMENT_FAILURE`, `DEPLOYMENT_STOP_ON_ALARM` and `DEPLOYMENT_STOP_ON_REQUEST`.
     * _Only one `auto_rollback_configuration` is allowed_.
     */
    @JvmName("wnddbunninhghhfv")
    public suspend fun events(values: List<Output<String>>) {
        this.events = Output.all(values)
    }

    /**
     * @param value Indicates whether a defined automatic rollback configuration is currently enabled for this Deployment Group. If you enable automatic rollback, you must specify at least one event type.
     */
    @JvmName("ehjggaldqwfdtbgn")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The event type or types that trigger a rollback. Supported types are `DEPLOYMENT_FAILURE`, `DEPLOYMENT_STOP_ON_ALARM` and `DEPLOYMENT_STOP_ON_REQUEST`.
     * _Only one `auto_rollback_configuration` is allowed_.
     */
    @JvmName("ruttdcthfpusnitr")
    public suspend fun events(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param values The event type or types that trigger a rollback. Supported types are `DEPLOYMENT_FAILURE`, `DEPLOYMENT_STOP_ON_ALARM` and `DEPLOYMENT_STOP_ON_REQUEST`.
     * _Only one `auto_rollback_configuration` is allowed_.
     */
    @JvmName("aspmswuiyneriikk")
    public suspend fun events(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    internal fun build(): DeploymentGroupAutoRollbackConfigurationArgs =
        DeploymentGroupAutoRollbackConfigurationArgs(
            enabled = enabled,
            events = events,
        )
}
