@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property actionOnTimeout When to reroute traffic from an original environment to a replacement environment in a blue/green deployment.
 * @property waitTimeInMinutes The number of minutes to wait before the status of a blue/green deployment changed to Stopped if rerouting is not started manually. Applies only to the `STOP_DEPLOYMENT` option for `action_on_timeout`.
 */
public data class DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs(
    public val actionOnTimeout: Output<String>? = null,
    public val waitTimeInMinutes: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs> {
    override fun toJava():
        com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs.builder()
            .actionOnTimeout(actionOnTimeout?.applyValue({ args0 -> args0 }))
            .waitTimeInMinutes(waitTimeInMinutes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs].
 */
@PulumiTagMarker
public class DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgsBuilder internal
constructor() {
    private var actionOnTimeout: Output<String>? = null

    private var waitTimeInMinutes: Output<Int>? = null

    /**
     * @param value When to reroute traffic from an original environment to a replacement environment in a blue/green deployment.
     */
    @JvmName("bkcebrogkuhaqcul")
    public suspend fun actionOnTimeout(`value`: Output<String>) {
        this.actionOnTimeout = value
    }

    /**
     * @param value The number of minutes to wait before the status of a blue/green deployment changed to Stopped if rerouting is not started manually. Applies only to the `STOP_DEPLOYMENT` option for `action_on_timeout`.
     */
    @JvmName("xbjdrfunmvsqiwyi")
    public suspend fun waitTimeInMinutes(`value`: Output<Int>) {
        this.waitTimeInMinutes = value
    }

    /**
     * @param value When to reroute traffic from an original environment to a replacement environment in a blue/green deployment.
     */
    @JvmName("txupvsyntsnbvuob")
    public suspend fun actionOnTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionOnTimeout = mapped
    }

    /**
     * @param value The number of minutes to wait before the status of a blue/green deployment changed to Stopped if rerouting is not started manually. Applies only to the `STOP_DEPLOYMENT` option for `action_on_timeout`.
     */
    @JvmName("htoldxepsfoxjyyv")
    public suspend fun waitTimeInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitTimeInMinutes = mapped
    }

    internal fun build(): DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs =
        DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs(
            actionOnTimeout = actionOnTimeout,
            waitTimeInMinutes = waitTimeInMinutes,
        )
}
