@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property action The action to take on instances in the original environment after a successful blue/green deployment.
 * @property terminationWaitTimeInMinutes The number of minutes to wait after a successful blue/green deployment before terminating instances from the original environment.
 */
public data class
DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs(
    public val action: Output<String>? = null,
    public val terminationWaitTimeInMinutes: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs> {
    override fun toJava():
        com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .terminationWaitTimeInMinutes(terminationWaitTimeInMinutes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs].
 */
@PulumiTagMarker
public class
DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgsBuilder
internal constructor() {
    private var action: Output<String>? = null

    private var terminationWaitTimeInMinutes: Output<Int>? = null

    /**
     * @param value The action to take on instances in the original environment after a successful blue/green deployment.
     */
    @JvmName("dkxiwxdypwkyfbgm")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value The number of minutes to wait after a successful blue/green deployment before terminating instances from the original environment.
     */
    @JvmName("bdktrnovwaufptmq")
    public suspend fun terminationWaitTimeInMinutes(`value`: Output<Int>) {
        this.terminationWaitTimeInMinutes = value
    }

    /**
     * @param value The action to take on instances in the original environment after a successful blue/green deployment.
     */
    @JvmName("ocaamlpyvrwjgudb")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The number of minutes to wait after a successful blue/green deployment before terminating instances from the original environment.
     */
    @JvmName("nytspukwumebugig")
    public suspend fun terminationWaitTimeInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminationWaitTimeInMinutes = mapped
    }

    internal fun build():
        DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs =
        DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs(
            action = action,
            terminationWaitTimeInMinutes = terminationWaitTimeInMinutes,
        )
}
