@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentGroupDeploymentStyleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deploymentOption Indicates whether to route deployment traffic behind a load balancer. Valid Values are `WITH_TRAFFIC_CONTROL` or `WITHOUT_TRAFFIC_CONTROL`. Default is `WITHOUT_TRAFFIC_CONTROL`.
 * @property deploymentType Indicates whether to run an in-place deployment or a blue/green deployment. Valid Values are `IN_PLACE` or `BLUE_GREEN`. Default is `IN_PLACE`.
 * _Only one `deployment_style` is allowed_.
 */
public data class DeploymentGroupDeploymentStyleArgs(
    public val deploymentOption: Output<String>? = null,
    public val deploymentType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentGroupDeploymentStyleArgs> {
    override fun toJava(): com.pulumi.aws.codedeploy.inputs.DeploymentGroupDeploymentStyleArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentGroupDeploymentStyleArgs.builder()
            .deploymentOption(deploymentOption?.applyValue({ args0 -> args0 }))
            .deploymentType(deploymentType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentGroupDeploymentStyleArgs].
 */
@PulumiTagMarker
public class DeploymentGroupDeploymentStyleArgsBuilder internal constructor() {
    private var deploymentOption: Output<String>? = null

    private var deploymentType: Output<String>? = null

    /**
     * @param value Indicates whether to route deployment traffic behind a load balancer. Valid Values are `WITH_TRAFFIC_CONTROL` or `WITHOUT_TRAFFIC_CONTROL`. Default is `WITHOUT_TRAFFIC_CONTROL`.
     */
    @JvmName("hohdmlspwhaqywpl")
    public suspend fun deploymentOption(`value`: Output<String>) {
        this.deploymentOption = value
    }

    /**
     * @param value Indicates whether to run an in-place deployment or a blue/green deployment. Valid Values are `IN_PLACE` or `BLUE_GREEN`. Default is `IN_PLACE`.
     * _Only one `deployment_style` is allowed_.
     */
    @JvmName("akxyoqsgtonjsxhc")
    public suspend fun deploymentType(`value`: Output<String>) {
        this.deploymentType = value
    }

    /**
     * @param value Indicates whether to route deployment traffic behind a load balancer. Valid Values are `WITH_TRAFFIC_CONTROL` or `WITHOUT_TRAFFIC_CONTROL`. Default is `WITHOUT_TRAFFIC_CONTROL`.
     */
    @JvmName("ulpiucmbkvbyvwvf")
    public suspend fun deploymentOption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentOption = mapped
    }

    /**
     * @param value Indicates whether to run an in-place deployment or a blue/green deployment. Valid Values are `IN_PLACE` or `BLUE_GREEN`. Default is `IN_PLACE`.
     * _Only one `deployment_style` is allowed_.
     */
    @JvmName("xrpopyjaopexpaag")
    public suspend fun deploymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentType = mapped
    }

    internal fun build(): DeploymentGroupDeploymentStyleArgs = DeploymentGroupDeploymentStyleArgs(
        deploymentOption = deploymentOption,
        deploymentType = deploymentType,
    )
}
