@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.inputs

import com.pulumi.aws.codedeploy.inputs.DeploymentGroupTriggerConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property triggerEvents The event type or types for which notifications are triggered. Some values that are supported: `DeploymentStart`, `DeploymentSuccess`, `DeploymentFailure`, `DeploymentStop`, `DeploymentRollback`, `InstanceStart`, `InstanceSuccess`, `InstanceFailure`.  See [the CodeDeploy documentation](http://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-sns-event-notifications-create-trigger.html) for all possible values.
 * @property triggerName The name of the notification trigger.
 * @property triggerTargetArn The ARN of the SNS topic through which notifications are sent.
 */
public data class DeploymentGroupTriggerConfigurationArgs(
    public val triggerEvents: Output<List<String>>,
    public val triggerName: Output<String>,
    public val triggerTargetArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codedeploy.inputs.DeploymentGroupTriggerConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.codedeploy.inputs.DeploymentGroupTriggerConfigurationArgs =
        com.pulumi.aws.codedeploy.inputs.DeploymentGroupTriggerConfigurationArgs.builder()
            .triggerEvents(triggerEvents.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .triggerName(triggerName.applyValue({ args0 -> args0 }))
            .triggerTargetArn(triggerTargetArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentGroupTriggerConfigurationArgs].
 */
@PulumiTagMarker
public class DeploymentGroupTriggerConfigurationArgsBuilder internal constructor() {
    private var triggerEvents: Output<List<String>>? = null

    private var triggerName: Output<String>? = null

    private var triggerTargetArn: Output<String>? = null

    /**
     * @param value The event type or types for which notifications are triggered. Some values that are supported: `DeploymentStart`, `DeploymentSuccess`, `DeploymentFailure`, `DeploymentStop`, `DeploymentRollback`, `InstanceStart`, `InstanceSuccess`, `InstanceFailure`.  See [the CodeDeploy documentation](http://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-sns-event-notifications-create-trigger.html) for all possible values.
     */
    @JvmName("ashapfjdaieexyro")
    public suspend fun triggerEvents(`value`: Output<List<String>>) {
        this.triggerEvents = value
    }

    @JvmName("gobypjoekdmlcmgc")
    public suspend fun triggerEvents(vararg values: Output<String>) {
        this.triggerEvents = Output.all(values.asList())
    }

    /**
     * @param values The event type or types for which notifications are triggered. Some values that are supported: `DeploymentStart`, `DeploymentSuccess`, `DeploymentFailure`, `DeploymentStop`, `DeploymentRollback`, `InstanceStart`, `InstanceSuccess`, `InstanceFailure`.  See [the CodeDeploy documentation](http://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-sns-event-notifications-create-trigger.html) for all possible values.
     */
    @JvmName("rhhctpcnxxnimbja")
    public suspend fun triggerEvents(values: List<Output<String>>) {
        this.triggerEvents = Output.all(values)
    }

    /**
     * @param value The name of the notification trigger.
     */
    @JvmName("sglbwmsoewmvepfv")
    public suspend fun triggerName(`value`: Output<String>) {
        this.triggerName = value
    }

    /**
     * @param value The ARN of the SNS topic through which notifications are sent.
     */
    @JvmName("ixuecisrylhdqmwn")
    public suspend fun triggerTargetArn(`value`: Output<String>) {
        this.triggerTargetArn = value
    }

    /**
     * @param value The event type or types for which notifications are triggered. Some values that are supported: `DeploymentStart`, `DeploymentSuccess`, `DeploymentFailure`, `DeploymentStop`, `DeploymentRollback`, `InstanceStart`, `InstanceSuccess`, `InstanceFailure`.  See [the CodeDeploy documentation](http://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-sns-event-notifications-create-trigger.html) for all possible values.
     */
    @JvmName("ncqykfymrsiikgkb")
    public suspend fun triggerEvents(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerEvents = mapped
    }

    /**
     * @param values The event type or types for which notifications are triggered. Some values that are supported: `DeploymentStart`, `DeploymentSuccess`, `DeploymentFailure`, `DeploymentStop`, `DeploymentRollback`, `InstanceStart`, `InstanceSuccess`, `InstanceFailure`.  See [the CodeDeploy documentation](http://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-sns-event-notifications-create-trigger.html) for all possible values.
     */
    @JvmName("awkfkuaostkijgyb")
    public suspend fun triggerEvents(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerEvents = mapped
    }

    /**
     * @param value The name of the notification trigger.
     */
    @JvmName("xyquvumdwfbcmder")
    public suspend fun triggerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerName = mapped
    }

    /**
     * @param value The ARN of the SNS topic through which notifications are sent.
     */
    @JvmName("udkgshihoriehtrw")
    public suspend fun triggerTargetArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerTargetArn = mapped
    }

    internal fun build(): DeploymentGroupTriggerConfigurationArgs =
        DeploymentGroupTriggerConfigurationArgs(
            triggerEvents = triggerEvents ?: throw PulumiNullFieldException("triggerEvents"),
            triggerName = triggerName ?: throw PulumiNullFieldException("triggerName"),
            triggerTargetArn = triggerTargetArn ?: throw PulumiNullFieldException("triggerTargetArn"),
        )
}
