@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property type The type can either be `FLEET_PERCENT` or `HOST_COUNT`.
 * @property value The value when the type is `FLEET_PERCENT` represents the minimum number of healthy instances as
 * a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the
 * deployment, AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional instances.
 * When the type is `HOST_COUNT`, the value represents the minimum number of healthy instances as an absolute value.
 */
public data class DeploymentConfigMinimumHealthyHosts(
    public val type: String? = null,
    public val `value`: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.codedeploy.outputs.DeploymentConfigMinimumHealthyHosts):
            DeploymentConfigMinimumHealthyHosts = DeploymentConfigMinimumHealthyHosts(
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
