@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property interval The number of minutes between each incremental traffic shift of a `TimeBasedLinear` deployment.
 * @property percentage The percentage of traffic that is shifted at the start of each increment of a `TimeBasedLinear` deployment.
 */
public data class DeploymentConfigTrafficRoutingConfigTimeBasedLinear(
    public val interval: Int? = null,
    public val percentage: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.codedeploy.outputs.DeploymentConfigTrafficRoutingConfigTimeBasedLinear):
            DeploymentConfigTrafficRoutingConfigTimeBasedLinear =
            DeploymentConfigTrafficRoutingConfigTimeBasedLinear(
                interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
                percentage = javaType.percentage().map({ args0 -> args0 }).orElse(null),
            )
    }
}
