@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property enabled Indicates whether a defined automatic rollback configuration is currently enabled for this Deployment Group. If you enable automatic rollback, you must specify at least one event type.
 * @property events The event type or types that trigger a rollback. Supported types are `DEPLOYMENT_FAILURE`, `DEPLOYMENT_STOP_ON_ALARM` and `DEPLOYMENT_STOP_ON_REQUEST`.
 * _Only one `auto_rollback_configuration` is allowed_.
 */
public data class DeploymentGroupAutoRollbackConfiguration(
    public val enabled: Boolean? = null,
    public val events: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.codedeploy.outputs.DeploymentGroupAutoRollbackConfiguration):
            DeploymentGroupAutoRollbackConfiguration = DeploymentGroupAutoRollbackConfiguration(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            events = javaType.events().map({ args0 -> args0 }),
        )
    }
}
