@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property actionOnTimeout When to reroute traffic from an original environment to a replacement environment in a blue/green deployment.
 * @property waitTimeInMinutes The number of minutes to wait before the status of a blue/green deployment changed to Stopped if rerouting is not started manually. Applies only to the `STOP_DEPLOYMENT` option for `action_on_timeout`.
 */
public data class DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOption(
    public val actionOnTimeout: String? = null,
    public val waitTimeInMinutes: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.codedeploy.outputs.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOption):
            DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOption =
            DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOption(
                actionOnTimeout = javaType.actionOnTimeout().map({ args0 -> args0 }).orElse(null),
                waitTimeInMinutes = javaType.waitTimeInMinutes().map({ args0 -> args0 }).orElse(null),
            )
    }
}
