@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deploymentOption Indicates whether to route deployment traffic behind a load balancer. Valid Values are `WITH_TRAFFIC_CONTROL` or `WITHOUT_TRAFFIC_CONTROL`. Default is `WITHOUT_TRAFFIC_CONTROL`.
 * @property deploymentType Indicates whether to run an in-place deployment or a blue/green deployment. Valid Values are `IN_PLACE` or `BLUE_GREEN`. Default is `IN_PLACE`.
 * _Only one `deployment_style` is allowed_.
 */
public data class DeploymentGroupDeploymentStyle(
    public val deploymentOption: String? = null,
    public val deploymentType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codedeploy.outputs.DeploymentGroupDeploymentStyle):
            DeploymentGroupDeploymentStyle = DeploymentGroupDeploymentStyle(
            deploymentOption = javaType.deploymentOption().map({ args0 -> args0 }).orElse(null),
            deploymentType = javaType.deploymentType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
