@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property elbInfos The Classic Elastic Load Balancer to use in a deployment. Conflicts with `target_group_info` and `target_group_pair_info`.
 * @property targetGroupInfos The (Application/Network Load Balancer) target group to use in a deployment. Conflicts with `elb_info` and `target_group_pair_info`.
 * @property targetGroupPairInfo The (Application/Network Load Balancer) target group pair to use in a deployment. Conflicts with `elb_info` and `target_group_info`.
 */
public data class DeploymentGroupLoadBalancerInfo(
    public val elbInfos: List<DeploymentGroupLoadBalancerInfoElbInfo>? = null,
    public val targetGroupInfos: List<DeploymentGroupLoadBalancerInfoTargetGroupInfo>? = null,
    public val targetGroupPairInfo: DeploymentGroupLoadBalancerInfoTargetGroupPairInfo? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.codedeploy.outputs.DeploymentGroupLoadBalancerInfo):
            DeploymentGroupLoadBalancerInfo = DeploymentGroupLoadBalancerInfo(
            elbInfos = javaType.elbInfos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupLoadBalancerInfoElbInfo.Companion.toKotlin(args0)
                })
            }),
            targetGroupInfos = javaType.targetGroupInfos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupLoadBalancerInfoTargetGroupInfo.Companion.toKotlin(args0)
                })
            }),
            targetGroupPairInfo = javaType.targetGroupPairInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfo.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
