@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The name of the load balancer that will be used to route traffic from original instances to replacement instances in a blue/green deployment. For in-place deployments, the name of the load balancer that instances are deregistered from so they are not serving traffic during a deployment, and then re-registered with after the deployment completes.
 */
public data class DeploymentGroupLoadBalancerInfoElbInfo(
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.codedeploy.outputs.DeploymentGroupLoadBalancerInfoElbInfo):
            DeploymentGroupLoadBalancerInfoElbInfo = DeploymentGroupLoadBalancerInfoElbInfo(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
