@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codegurureviewer.kotlin

import com.pulumi.aws.codegurureviewer.RepositoryAssociationArgs.builder
import com.pulumi.aws.codegurureviewer.kotlin.inputs.RepositoryAssociationKmsKeyDetailsArgs
import com.pulumi.aws.codegurureviewer.kotlin.inputs.RepositoryAssociationKmsKeyDetailsArgsBuilder
import com.pulumi.aws.codegurureviewer.kotlin.inputs.RepositoryAssociationRepositoryArgs
import com.pulumi.aws.codegurureviewer.kotlin.inputs.RepositoryAssociationRepositoryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS CodeGuru Reviewer Repository Association.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.codecommit.Repository;
 * import com.pulumi.aws.codecommit.RepositoryArgs;
 * import com.pulumi.aws.codegurureviewer.RepositoryAssociation;
 * import com.pulumi.aws.codegurureviewer.RepositoryAssociationArgs;
 * import com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryArgs;
 * import com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryCodecommitArgs;
 * import com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationKmsKeyDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey");
 *         var exampleRepository = new Repository("exampleRepository", RepositoryArgs.builder()
 *             .repositoryName("example-repo")
 *             .build());
 *         var exampleRepositoryAssociation = new RepositoryAssociation("exampleRepositoryAssociation", RepositoryAssociationArgs.builder()
 *             .repository(RepositoryAssociationRepositoryArgs.builder()
 *                 .codecommit(RepositoryAssociationRepositoryCodecommitArgs.builder()
 *                     .name(exampleRepository.repositoryName())
 *                     .build())
 *                 .build())
 *             .kmsKeyDetails(RepositoryAssociationKmsKeyDetailsArgs.builder()
 *                 .encryptionOption("CUSTOMER_MANAGED_CMK")
 *                 .kmsKeyId(exampleKey.keyId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * @property kmsKeyDetails An object describing the KMS key to asssociate. Block is documented below.
 * @property repository An object describing the repository to associate. Valid values: `bitbucket`, `codecommit`, `github_enterprise_server`, or `s3_bucket`. Block is documented below. Note: for repositories that leverage CodeStar connections (ex. `bitbucket`, `github_enterprise_server`) the connection must be in `Available` status prior to creating this resource.
 * The following arguments are optional:
 * @property tags
 */
public data class RepositoryAssociationArgs(
    public val kmsKeyDetails: Output<RepositoryAssociationKmsKeyDetailsArgs>? = null,
    public val repository: Output<RepositoryAssociationRepositoryArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codegurureviewer.RepositoryAssociationArgs> {
    override fun toJava(): com.pulumi.aws.codegurureviewer.RepositoryAssociationArgs =
        com.pulumi.aws.codegurureviewer.RepositoryAssociationArgs.builder()
            .kmsKeyDetails(kmsKeyDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .repository(repository?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RepositoryAssociationArgs].
 */
@PulumiTagMarker
public class RepositoryAssociationArgsBuilder internal constructor() {
    private var kmsKeyDetails: Output<RepositoryAssociationKmsKeyDetailsArgs>? = null

    private var repository: Output<RepositoryAssociationRepositoryArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value An object describing the KMS key to asssociate. Block is documented below.
     */
    @JvmName("amakmubrorydxeee")
    public suspend fun kmsKeyDetails(`value`: Output<RepositoryAssociationKmsKeyDetailsArgs>) {
        this.kmsKeyDetails = value
    }

    /**
     * @param value An object describing the repository to associate. Valid values: `bitbucket`, `codecommit`, `github_enterprise_server`, or `s3_bucket`. Block is documented below. Note: for repositories that leverage CodeStar connections (ex. `bitbucket`, `github_enterprise_server`) the connection must be in `Available` status prior to creating this resource.
     * The following arguments are optional:
     */
    @JvmName("uunykjhbastdrqlx")
    public suspend fun repository(`value`: Output<RepositoryAssociationRepositoryArgs>) {
        this.repository = value
    }

    /**
     * @param value
     */
    @JvmName("gwllfqnopdbuviim")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value An object describing the KMS key to asssociate. Block is documented below.
     */
    @JvmName("hbvymojgdhmskrdc")
    public suspend fun kmsKeyDetails(`value`: RepositoryAssociationKmsKeyDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyDetails = mapped
    }

    /**
     * @param argument An object describing the KMS key to asssociate. Block is documented below.
     */
    @JvmName("igxnwervlmlbncxq")
    public suspend
    fun kmsKeyDetails(argument: suspend RepositoryAssociationKmsKeyDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = RepositoryAssociationKmsKeyDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kmsKeyDetails = mapped
    }

    /**
     * @param value An object describing the repository to associate. Valid values: `bitbucket`, `codecommit`, `github_enterprise_server`, or `s3_bucket`. Block is documented below. Note: for repositories that leverage CodeStar connections (ex. `bitbucket`, `github_enterprise_server`) the connection must be in `Available` status prior to creating this resource.
     * The following arguments are optional:
     */
    @JvmName("qeajxmhdmndjklme")
    public suspend fun repository(`value`: RepositoryAssociationRepositoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repository = mapped
    }

    /**
     * @param argument An object describing the repository to associate. Valid values: `bitbucket`, `codecommit`, `github_enterprise_server`, or `s3_bucket`. Block is documented below. Note: for repositories that leverage CodeStar connections (ex. `bitbucket`, `github_enterprise_server`) the connection must be in `Available` status prior to creating this resource.
     * The following arguments are optional:
     */
    @JvmName("btqnbhigerjuhwwr")
    public suspend
    fun repository(argument: suspend RepositoryAssociationRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = RepositoryAssociationRepositoryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.repository = mapped
    }

    /**
     * @param value
     */
    @JvmName("shirfnejvjaufekr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("vvvkktgapxbicaqm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RepositoryAssociationArgs = RepositoryAssociationArgs(
        kmsKeyDetails = kmsKeyDetails,
        repository = repository,
        tags = tags,
    )
}
