@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codegurureviewer.kotlin.inputs

import com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryBitbucketArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionArn The Amazon Resource Name (ARN) of an AWS CodeStar Connections connection.
 * @property name The name of the third party source repository.
 * @property owner The username for the account that owns the repository.
 */
public data class RepositoryAssociationRepositoryBitbucketArgs(
    public val connectionArn: Output<String>,
    public val name: Output<String>,
    public val owner: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryBitbucketArgs> {
    override fun toJava():
        com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryBitbucketArgs =
        com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryBitbucketArgs.builder()
            .connectionArn(connectionArn.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .owner(owner.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RepositoryAssociationRepositoryBitbucketArgs].
 */
@PulumiTagMarker
public class RepositoryAssociationRepositoryBitbucketArgsBuilder internal constructor() {
    private var connectionArn: Output<String>? = null

    private var name: Output<String>? = null

    private var owner: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of an AWS CodeStar Connections connection.
     */
    @JvmName("ihtwkvwehopocars")
    public suspend fun connectionArn(`value`: Output<String>) {
        this.connectionArn = value
    }

    /**
     * @param value The name of the third party source repository.
     */
    @JvmName("wqggxxookubviwdt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The username for the account that owns the repository.
     */
    @JvmName("qlvqemxsoxiqmttb")
    public suspend fun owner(`value`: Output<String>) {
        this.owner = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of an AWS CodeStar Connections connection.
     */
    @JvmName("oemfvdixeuqptxuu")
    public suspend fun connectionArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionArn = mapped
    }

    /**
     * @param value The name of the third party source repository.
     */
    @JvmName("rbkokwkqatnlvaud")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The username for the account that owns the repository.
     */
    @JvmName("bkmkvsojkshkesfo")
    public suspend fun owner(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.owner = mapped
    }

    internal fun build(): RepositoryAssociationRepositoryBitbucketArgs =
        RepositoryAssociationRepositoryBitbucketArgs(
            connectionArn = connectionArn ?: throw PulumiNullFieldException("connectionArn"),
            name = name ?: throw PulumiNullFieldException("name"),
            owner = owner ?: throw PulumiNullFieldException("owner"),
        )
}
