@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codegurureviewer.kotlin.inputs

import com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryS3BucketArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName The name of the S3 bucket used for associating a new S3 repository. Note: The name must begin with `codeguru-reviewer-`.
 * @property name The name of the third party source repository.
 */
public data class RepositoryAssociationRepositoryS3BucketArgs(
    public val bucketName: Output<String>,
    public val name: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryS3BucketArgs> {
    override fun toJava():
        com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryS3BucketArgs =
        com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryS3BucketArgs.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RepositoryAssociationRepositoryS3BucketArgs].
 */
@PulumiTagMarker
public class RepositoryAssociationRepositoryS3BucketArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The name of the S3 bucket used for associating a new S3 repository. Note: The name must begin with `codeguru-reviewer-`.
     */
    @JvmName("spxeypoxjvojqnka")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value The name of the third party source repository.
     */
    @JvmName("egkvwbyepjkwvnyk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the S3 bucket used for associating a new S3 repository. Note: The name must begin with `codeguru-reviewer-`.
     */
    @JvmName("phauvfkqbvdrnalo")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value The name of the third party source repository.
     */
    @JvmName("vjbjjqkrrktfpbnt")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): RepositoryAssociationRepositoryS3BucketArgs =
        RepositoryAssociationRepositoryS3BucketArgs(
            bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
