@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codegurureviewer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property encryptionOption The encryption option for a repository association. It is either owned by AWS Key Management Service (KMS) (`AWS_OWNED_CMK`) or customer managed (`CUSTOMER_MANAGED_CMK`).
 * @property kmsKeyId The ID of the AWS KMS key that is associated with a repository association.
 */
public data class RepositoryAssociationKmsKeyDetails(
    public val encryptionOption: String? = null,
    public val kmsKeyId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.codegurureviewer.outputs.RepositoryAssociationKmsKeyDetails):
            RepositoryAssociationKmsKeyDetails = RepositoryAssociationKmsKeyDetails(
            encryptionOption = javaType.encryptionOption().map({ args0 -> args0 }).orElse(null),
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
