@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codegurureviewer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property connectionArn The Amazon Resource Name (ARN) of an AWS CodeStar Connections connection.
 * @property name The name of the third party source repository.
 * @property owner The username for the account that owns the repository.
 */
public data class RepositoryAssociationRepositoryGithubEnterpriseServer(
    public val connectionArn: String,
    public val name: String,
    public val owner: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.codegurureviewer.outputs.RepositoryAssociationRepositoryGithubEnterpriseServer):
            RepositoryAssociationRepositoryGithubEnterpriseServer =
            RepositoryAssociationRepositoryGithubEnterpriseServer(
                connectionArn = javaType.connectionArn(),
                name = javaType.name(),
                owner = javaType.owner(),
            )
    }
}
