@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codegurureviewer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName The name of the S3 bucket used for associating a new S3 repository. Note: The name must begin with `codeguru-reviewer-`.
 * @property name The name of the third party source repository.
 */
public data class RepositoryAssociationRepositoryS3Bucket(
    public val bucketName: String,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.codegurureviewer.outputs.RepositoryAssociationRepositoryS3Bucket):
            RepositoryAssociationRepositoryS3Bucket = RepositoryAssociationRepositoryS3Bucket(
            bucketName = javaType.bucketName(),
            name = javaType.name(),
        )
    }
}
