@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codegurureviewer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bucketName The name of the S3 bucket used for associating a new S3 repository. Note: The name must begin with `codeguru-reviewer-`.
 * @property codeArtifacts
 */
public data class RepositoryAssociationS3RepositoryDetail(
    public val bucketName: String? = null,
    public val codeArtifacts: List<RepositoryAssociationS3RepositoryDetailCodeArtifact>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.codegurureviewer.outputs.RepositoryAssociationS3RepositoryDetail):
            RepositoryAssociationS3RepositoryDetail = RepositoryAssociationS3RepositoryDetail(
            bucketName = javaType.bucketName().map({ args0 -> args0 }).orElse(null),
            codeArtifacts = javaType.codeArtifacts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codegurureviewer.kotlin.outputs.RepositoryAssociationS3RepositoryDetailCodeArtifact.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
